/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.DERGeneralizedTime;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class GeneralizedTimeTest
extends SimpleTest {
    String[] input = new String[]{"20020122122220", "20020122122220Z", "20020122122220-1000", "20020122122220+00", "20020122122220.1", "20020122122220.1Z", "20020122122220.1-1000", "20020122122220.1+00", "20020122122220.01", "20020122122220.01Z", "20020122122220.01-1000", "20020122122220.01+00", "20020122122220.001", "20020122122220.001Z", "20020122122220.001-1000", "20020122122220.001+00", "20020122122220.0001", "20020122122220.0001Z", "20020122122220.0001-1000", "20020122122220.0001+00", "20020122122220.0001+1000"};
    String[] output = new String[]{"20020122122220", "20020122122220GMT+00:00", "20020122122220GMT-10:00", "20020122122220GMT+00:00", "20020122122220.1", "20020122122220.1GMT+00:00", "20020122122220.1GMT-10:00", "20020122122220.1GMT+00:00", "20020122122220.01", "20020122122220.01GMT+00:00", "20020122122220.01GMT-10:00", "20020122122220.01GMT+00:00", "20020122122220.001", "20020122122220.001GMT+00:00", "20020122122220.001GMT-10:00", "20020122122220.001GMT+00:00", "20020122122220.0001", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT-10:00", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT+10:00"};
    String[] zOutput = new String[]{"20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122022220Z"};
    String[] mzOutput = new String[]{"20020122122220.000Z", "20020122122220.000Z", "20020122222220.000Z", "20020122122220.000Z", "20020122122220.100Z", "20020122122220.100Z", "20020122222220.100Z", "20020122122220.100Z", "20020122122220.010Z", "20020122122220.010Z", "20020122222220.010Z", "20020122122220.010Z", "20020122122220.001Z", "20020122122220.001Z", "20020122222220.001Z", "20020122122220.001Z", "20020122122220.000Z", "20020122122220.000Z", "20020122222220.000Z", "20020122122220.000Z", "20020122022220.000Z"};

    public String getName() {
        return "GeneralizedTime";
    }

    public void performTest() throws Exception {
        DERGeneralizedTime dERGeneralizedTime;
        int n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        for (n = 0; n != this.input.length; ++n) {
            dERGeneralizedTime = new DERGeneralizedTime(this.input[n]);
            if (this.output[n].indexOf(71) > 0) {
                if (!dERGeneralizedTime.getTime().equals(this.output[n])) {
                    this.fail("failed conversion test");
                }
                if (simpleDateFormat.format(dERGeneralizedTime.getDate()).equals(this.zOutput[n])) continue;
                this.fail("failed date conversion test");
                continue;
            }
            String string = this.calculateGMTOffset(dERGeneralizedTime.getDate());
            if (dERGeneralizedTime.getTime().equals(this.output[n] + string)) continue;
            this.fail("failed conversion test");
        }
        simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        for (n = 0; n != this.input.length; ++n) {
            dERGeneralizedTime = new DERGeneralizedTime(this.input[n]);
            if (simpleDateFormat.format(dERGeneralizedTime.getDate()).equals(this.mzOutput[n])) continue;
            this.fail("failed long date conversion test");
        }
    }

    private String calculateGMTOffset(Date date) {
        String string = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        if (n < 0) {
            string = "-";
            n = -n;
        }
        int n2 = n / 3600000;
        int n3 = (n - n2 * 60 * 60 * 1000) / 60000;
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(date)) {
            n2 += string.equals("+") ? 1 : -1;
        }
        return "GMT" + string + this.convert(n2) + ":" + this.convert(n3);
    }

    private String convert(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n);
    }

    public static void main(String[] stringArray) {
        GeneralizedTimeTest.runTest(new GeneralizedTimeTest());
    }
}

