/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERBitString;
import edu.illinois.ncsa.bouncycastle.asn1.cmp.PKIFailureInfo;
import edu.illinois.ncsa.bouncycastle.asn1.test.BitStringConstantTester;
import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class PKIFailureInfoTest
extends SimpleTest {
    private static final byte[] CORRECT_FAILURE_INFO = Base64.decode("AwIANQ==");

    public String getName() {
        return "PKIFailureInfo";
    }

    private void testEncoding() throws IOException {
        DERBitString dERBitString = (DERBitString)new ASN1InputStream(CORRECT_FAILURE_INFO).readObject();
        PKIFailureInfo pKIFailureInfo = new PKIFailureInfo(dERBitString);
        PKIFailureInfo pKIFailureInfo2 = new PKIFailureInfo(53);
        if (!this.areEqual(pKIFailureInfo.getDEREncoded(), pKIFailureInfo2.getDEREncoded())) {
            this.fail("encoding doesn't match");
        }
    }

    public void performTest() throws IOException {
        BitStringConstantTester.testFlagValueCorrect(0, 128);
        BitStringConstantTester.testFlagValueCorrect(1, 64);
        BitStringConstantTester.testFlagValueCorrect(2, 32);
        BitStringConstantTester.testFlagValueCorrect(3, 16);
        BitStringConstantTester.testFlagValueCorrect(4, 8);
        BitStringConstantTester.testFlagValueCorrect(5, 4);
        BitStringConstantTester.testFlagValueCorrect(6, 2);
        BitStringConstantTester.testFlagValueCorrect(7, 1);
        BitStringConstantTester.testFlagValueCorrect(8, 32768);
        BitStringConstantTester.testFlagValueCorrect(9, 16384);
        BitStringConstantTester.testFlagValueCorrect(14, 512);
        BitStringConstantTester.testFlagValueCorrect(15, 256);
        BitStringConstantTester.testFlagValueCorrect(16, 0x800000);
        BitStringConstantTester.testFlagValueCorrect(17, 0x400000);
        BitStringConstantTester.testFlagValueCorrect(25, 0x40000000);
        this.testEncoding();
    }

    public static void main(String[] stringArray) {
        PKIFailureInfoTest.runTest(new PKIFailureInfoTest());
    }
}

