/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DEROctetString;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.ProcurationSyntax;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import java.io.IOException;

public class ProfessionInfoUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "ProfessionInfo";
    }

    public void performTest() throws Exception {
        NamingAuthority namingAuthority = new NamingAuthority(new DERObjectIdentifier("1.2.3"), "url", new DirectoryString("fred"));
        DirectoryString[] directoryStringArray = new DirectoryString[]{new DirectoryString("substitution")};
        DERObjectIdentifier[] dERObjectIdentifierArray = new DERObjectIdentifier[]{new DERObjectIdentifier("1.2.3")};
        String string = "12345";
        DEROctetString dEROctetString = new DEROctetString(new byte[20]);
        ProfessionInfo professionInfo = new ProfessionInfo(namingAuthority, directoryStringArray, dERObjectIdentifierArray, string, dEROctetString);
        this.checkConstruction(professionInfo, namingAuthority, directoryStringArray, dERObjectIdentifierArray, string, dEROctetString);
        professionInfo = new ProfessionInfo(null, directoryStringArray, dERObjectIdentifierArray, string, dEROctetString);
        this.checkConstruction(professionInfo, null, directoryStringArray, dERObjectIdentifierArray, string, dEROctetString);
        professionInfo = new ProfessionInfo(namingAuthority, directoryStringArray, null, string, dEROctetString);
        this.checkConstruction(professionInfo, namingAuthority, directoryStringArray, null, string, dEROctetString);
        professionInfo = new ProfessionInfo(namingAuthority, directoryStringArray, dERObjectIdentifierArray, null, dEROctetString);
        this.checkConstruction(professionInfo, namingAuthority, directoryStringArray, dERObjectIdentifierArray, null, dEROctetString);
        professionInfo = new ProfessionInfo(namingAuthority, directoryStringArray, dERObjectIdentifierArray, string, null);
        this.checkConstruction(professionInfo, namingAuthority, directoryStringArray, dERObjectIdentifierArray, string, null);
        professionInfo = ProfessionInfo.getInstance(null);
        if (professionInfo != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            ProcurationSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(ProfessionInfo professionInfo, NamingAuthority namingAuthority, DirectoryString[] directoryStringArray, DERObjectIdentifier[] dERObjectIdentifierArray, String string, DEROctetString dEROctetString) throws IOException {
        this.checkValues(professionInfo, namingAuthority, directoryStringArray, dERObjectIdentifierArray, string, dEROctetString);
        professionInfo = ProfessionInfo.getInstance(professionInfo);
        this.checkValues(professionInfo, namingAuthority, directoryStringArray, dERObjectIdentifierArray, string, dEROctetString);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(professionInfo.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        professionInfo = ProfessionInfo.getInstance(aSN1Sequence);
        this.checkValues(professionInfo, namingAuthority, directoryStringArray, dERObjectIdentifierArray, string, dEROctetString);
    }

    private void checkValues(ProfessionInfo professionInfo, NamingAuthority namingAuthority, DirectoryString[] directoryStringArray, DERObjectIdentifier[] dERObjectIdentifierArray, String string, DEROctetString dEROctetString) {
        this.checkOptionalField("auth", namingAuthority, professionInfo.getNamingAuthority());
        this.checkMandatoryField("professionItems", directoryStringArray[0], professionInfo.getProfessionItems()[0]);
        if (dERObjectIdentifierArray != null) {
            this.checkOptionalField("professionOids", dERObjectIdentifierArray[0], professionInfo.getProfessionOIDs()[0]);
        }
        this.checkOptionalField("registrationNumber", string, professionInfo.getRegistrationNumber());
        this.checkOptionalField("addProfessionInfo", dEROctetString, professionInfo.getAddProfessionInfo());
    }

    public static void main(String[] stringArray) {
        ProfessionInfoUnitTest.runTest(new ProfessionInfoUnitTest());
    }
}

