/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERTaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERUTF8String;
import edu.illinois.ncsa.bouncycastle.asn1.esf.SignerLocation;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class SignerLocationUnitTest
extends SimpleTest {
    public String getName() {
        return "SignerLocation";
    }

    public void performTest() throws Exception {
        DERUTF8String dERUTF8String = new DERUTF8String("Australia");
        SignerLocation signerLocation = new SignerLocation(dERUTF8String, null, null);
        this.checkConstruction(signerLocation, dERUTF8String, null, null);
        DERUTF8String dERUTF8String2 = new DERUTF8String("Melbourne");
        signerLocation = new SignerLocation(null, dERUTF8String2, null);
        this.checkConstruction(signerLocation, null, dERUTF8String2, null);
        signerLocation = new SignerLocation(dERUTF8String, dERUTF8String2, null);
        this.checkConstruction(signerLocation, dERUTF8String, dERUTF8String2, null);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERUTF8String("line 1"));
        aSN1EncodableVector.add(new DERUTF8String("line 2"));
        DERSequence dERSequence = new DERSequence(aSN1EncodableVector);
        signerLocation = new SignerLocation(null, null, dERSequence);
        this.checkConstruction(signerLocation, null, null, dERSequence);
        signerLocation = new SignerLocation(dERUTF8String, null, dERSequence);
        this.checkConstruction(signerLocation, dERUTF8String, null, dERSequence);
        signerLocation = new SignerLocation(dERUTF8String, dERUTF8String2, dERSequence);
        this.checkConstruction(signerLocation, dERUTF8String, dERUTF8String2, dERSequence);
        signerLocation = SignerLocation.getInstance(null);
        if (signerLocation != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            SignerLocation.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERUTF8String("line 1"));
        aSN1EncodableVector.add(new DERUTF8String("line 2"));
        aSN1EncodableVector.add(new DERUTF8String("line 3"));
        aSN1EncodableVector.add(new DERUTF8String("line 4"));
        aSN1EncodableVector.add(new DERUTF8String("line 5"));
        aSN1EncodableVector.add(new DERUTF8String("line 6"));
        aSN1EncodableVector.add(new DERUTF8String("line 7"));
        dERSequence = new DERSequence(aSN1EncodableVector);
        try {
            new SignerLocation(null, null, dERSequence);
            this.fail("constructor failed to detect bad postalAddress.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SignerLocation(new DERSequence(new DERTaggedObject(2, dERSequence)));
            this.fail("sequence constructor failed to detect bad postalAddress.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SignerLocation(new DERSequence(new DERTaggedObject(5, dERSequence)));
            this.fail("sequence constructor failed to detect bad tag.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(SignerLocation signerLocation, DERUTF8String dERUTF8String, DERUTF8String dERUTF8String2, ASN1Sequence aSN1Sequence) throws IOException {
        this.checkValues(signerLocation, dERUTF8String, dERUTF8String2, aSN1Sequence);
        signerLocation = SignerLocation.getInstance(signerLocation);
        this.checkValues(signerLocation, dERUTF8String, dERUTF8String2, aSN1Sequence);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(signerLocation.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1InputStream.readObject();
        signerLocation = SignerLocation.getInstance(aSN1Sequence2);
        this.checkValues(signerLocation, dERUTF8String, dERUTF8String2, aSN1Sequence);
    }

    private void checkValues(SignerLocation signerLocation, DERUTF8String dERUTF8String, DERUTF8String dERUTF8String2, ASN1Sequence aSN1Sequence) {
        if (dERUTF8String != null) {
            if (!dERUTF8String.equals(signerLocation.getCountryName())) {
                this.fail("countryNames don't match.");
            }
        } else if (signerLocation.getCountryName() != null) {
            this.fail("countryName found when none expected.");
        }
        if (dERUTF8String2 != null) {
            if (!dERUTF8String2.equals(signerLocation.getLocalityName())) {
                this.fail("localityNames don't match.");
            }
        } else if (signerLocation.getLocalityName() != null) {
            this.fail("localityName found when none expected.");
        }
        if (aSN1Sequence != null) {
            if (!aSN1Sequence.equals(signerLocation.getPostalAddress())) {
                this.fail("postalAddresses don't match.");
            }
        } else if (signerLocation.getPostalAddress() != null) {
            this.fail("postalAddress found when none expected.");
        }
    }

    public static void main(String[] stringArray) {
        SignerLocationUnitTest.runTest(new SignerLocationUnitTest());
    }
}

