/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import edu.illinois.ncsa.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import edu.illinois.ncsa.bouncycastle.crypto.DerivationFunction;
import edu.illinois.ncsa.bouncycastle.crypto.DerivationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.kdf.ECDHKEKGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA1Digest;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class ECDHKEKGeneratorTest
extends SimpleTest {
    private byte[] seed1 = Hex.decode("db4a8daba1f98791d54e940175dd1a5f3a0826a1066aa9b668d4dc1e1e0790158dcad1533c03b44214d1b61fefa8b579");
    private DERObjectIdentifier alg1 = NISTObjectIdentifiers.id_aes256_wrap;
    private byte[] result1 = Hex.decode("8ecc6d85caf25eaba823a7d620d4ab0d33e4c645f2");
    private byte[] seed2 = Hex.decode("75d7487b5d3d2bfb3c69ce0365fe64e3bfab5d0d63731628a9f47eb8fddfa28c65decaf228a0b38f0c51c6a3356d7c56");
    private DERObjectIdentifier alg2 = NISTObjectIdentifiers.id_aes128_wrap;
    private byte[] result2 = Hex.decode("042be1faca3a4a8fc859241bfb87ba35");
    private byte[] seed3 = Hex.decode("fdeb6d809f997e8ac174d638734dc36d37aaf7e876e39967cd82b1cada3de772449788461ee7f856bad9305627f8e48b");
    private DERObjectIdentifier alg3 = PKCSObjectIdentifiers.id_alg_CMS3DESwrap;
    private byte[] result3 = Hex.decode("bcd701fc92109b1b9d6f3b6497ad5ca9627fa8a597010305");

    public void performTest() {
        this.checkMask(1, new ECDHKEKGenerator(new SHA1Digest()), new DHKDFParameters(this.alg1, 256, this.seed1), this.result1);
        this.checkMask(2, new ECDHKEKGenerator(new SHA1Digest()), new DHKDFParameters(this.alg2, 128, this.seed2), this.result2);
        this.checkMask(3, new ECDHKEKGenerator(new SHA1Digest()), new DHKDFParameters(this.alg3, 192, this.seed3), this.result3);
    }

    private void checkMask(int n, DerivationFunction derivationFunction, DerivationParameters derivationParameters, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        derivationFunction.init(derivationParameters);
        derivationFunction.generateBytes(byArray2, 0, byArray2.length);
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("ECDHKEKGenerator failed generator test " + n);
        }
    }

    public String getName() {
        return "ECDHKEKGenerator";
    }

    public static void main(String[] stringArray) {
        ECDHKEKGeneratorTest.runTest(new ECDHKEKGeneratorTest());
    }
}

