/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.DataLengthException;
import edu.illinois.ncsa.bouncycastle.crypto.engines.NullEngine;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.test.BlockCipherVectorTest;
import edu.illinois.ncsa.bouncycastle.crypto.test.CipherTest;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class NullTest
extends CipherTest {
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, new NullEngine(), new KeyParameter(Hex.decode("00")), "00", "00")};

    NullTest() {
        super(tests, new NullEngine(), new KeyParameter(new byte[2]));
    }

    public String getName() {
        return "Null";
    }

    public void performTest() throws Exception {
        super.performTest();
        NullEngine nullEngine = new NullEngine();
        nullEngine.init(true, null);
        byte[] byArray = new byte[1];
        nullEngine.processBlock(byArray, 0, byArray, 0);
        if (byArray[0] != 0) {
            this.fail("NullCipher changed data!");
        }
        byte[] byArray2 = new byte[]{};
        try {
            nullEngine.processBlock(byArray2, 0, byArray, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        try {
            nullEngine.processBlock(byArray, 0, byArray2, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        NullTest.runTest(new NullTest());
    }
}

