/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.Signer;
import edu.illinois.ncsa.bouncycastle.crypto.io.SignerInputStream;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHPublicKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.tls.SecurityParameters;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsClientContext;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsDHKeyExchange;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsFatalAlert;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsSigner;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    TlsDHEKeyExchange(TlsClientContext tlsClientContext, int n) {
        super(tlsClientContext, n);
    }

    public void skipServerKeyExchange() throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initSigner(this.tlsSigner, securityParameters);
        SignerInputStream signerInputStream = new SignerInputStream(inputStream, signer);
        byte[] byArray = TlsUtils.readOpaque16(signerInputStream);
        byte[] byArray2 = TlsUtils.readOpaque16(signerInputStream);
        byte[] byArray3 = TlsUtils.readOpaque16(signerInputStream);
        byte[] byArray4 = TlsUtils.readOpaque16(inputStream);
        if (!signer.verifySignature(byArray4)) {
            throw new TlsFatalAlert(42);
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        BigInteger bigInteger3 = new BigInteger(1, byArray3);
        this.dhAgreeServerPublicKey = this.validateDHPublicKey(new DHPublicKeyParameters(bigInteger3, new DHParameters(bigInteger, bigInteger2)));
    }

    protected Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

