/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.CryptoException;
import edu.illinois.ncsa.bouncycastle.crypto.DSA;
import edu.illinois.ncsa.bouncycastle.crypto.Signer;
import edu.illinois.ncsa.bouncycastle.crypto.digests.NullDigest;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA1Digest;
import edu.illinois.ncsa.bouncycastle.crypto.params.AsymmetricKeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithRandom;
import edu.illinois.ncsa.bouncycastle.crypto.signers.DSADigestSigner;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsSigner;
import java.security.SecureRandom;

abstract class TlsDSASigner
implements TlsSigner {
    TlsDSASigner() {
    }

    public byte[] calculateRawSignature(SecureRandom secureRandom, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(), new NullDigest());
        dSADigestSigner.init(true, new ParametersWithRandom(asymmetricKeyParameter, secureRandom));
        dSADigestSigner.update(byArray, 16, 20);
        return dSADigestSigner.generateSignature();
    }

    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(), new SHA1Digest());
        dSADigestSigner.init(false, asymmetricKeyParameter);
        return dSADigestSigner;
    }

    protected abstract DSA createDSAImpl();
}

