/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.CryptoException;
import edu.illinois.ncsa.bouncycastle.crypto.Signer;
import edu.illinois.ncsa.bouncycastle.crypto.digests.NullDigest;
import edu.illinois.ncsa.bouncycastle.crypto.encodings.PKCS1Encoding;
import edu.illinois.ncsa.bouncycastle.crypto.engines.RSABlindedEngine;
import edu.illinois.ncsa.bouncycastle.crypto.params.AsymmetricKeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithRandom;
import edu.illinois.ncsa.bouncycastle.crypto.params.RSAKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.signers.GenericSigner;
import edu.illinois.ncsa.bouncycastle.crypto.tls.CombinedHash;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsSigner;
import java.security.SecureRandom;

class TlsRSASigner
implements TlsSigner {
    TlsRSASigner() {
    }

    public byte[] calculateRawSignature(SecureRandom secureRandom, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        GenericSigner genericSigner = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new NullDigest());
        genericSigner.init(true, new ParametersWithRandom(asymmetricKeyParameter, secureRandom));
        genericSigner.update(byArray, 0, byArray.length);
        return genericSigner.generateSignature();
    }

    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        GenericSigner genericSigner = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new CombinedHash());
        genericSigner.init(false, asymmetricKeyParameter);
        return genericSigner;
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof RSAKeyParameters && !asymmetricKeyParameter.isPrivate();
    }
}

