/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class DDCopy {
    private static final long KILO = 1024L;
    private static final long MEGA = 0x100000L;
    private static final long GIGA = 0x40000000L;
    private static final long TERA = 0x10000000000L;
    private static final long PETA = 0x4000000000000L;
    private static final String USAGE_MESSAGE = "\nUsage: java -cp fdt.jar " + DDCopy.class.getName() + " [ OPTIONS ] ARGS\n\nARGS: if=<sourceFile> of=<destinationFile>\n\n\nWhere OPTIONS can be:\n\n   bs=<BufferSize>[K|M]\t size of the buffer used for read/write.\n   \t\t\t [K(ilo) | M(ega)] may be used as suffixes. Default 4K\n   bn=<NoOfBuffers>\t Number of buffers used to readv()/writev() at once.\n   \t\t\t If this parameter is 1, or is missing the program will \n   \t\t\t read()/write() a single buffer at a time, otherwise \n   \t\t\t the readv()/writev() will be used. Default is 1\n   count=<count>\t Number of \"blocks\" to write.\n   \t\t\t A \"block\" is represents how much data is read/write\n   \t\t\t The size of a \"block\" is: <BufferSize>*<BuffersNumber>\n   \t\t\t If <count> <= 0 the copy stops when EOF is reached\n   \t\t\t reading the <SourceFile>. The default is 0\n   statsdelay=<seconds>\t Number of seconds between reports.\n   \t\t\t Default is 2 seconds. If <seconds> <= 0 no reports \n   \t\t\t will be printed\n   flags=<flag>\t\t The <flag> field can have of the following values: \n   \t\t\t    SYNC   For every write both data and metadata are\n   \t\t\t           written synchronously\n   \t\t\t    DSYCN  Same as SYNC, but only the data is written\n   \t\t\t           synchronously.\n   \t\t\t    NOSYNC The sync() is left to be done by the\n   \t\t\t           underlying OS\n   \t\t\t The default value is DSYNC\n   rformat=<rformat>\t Report format. Possible values are:\n   \t\t\t    K - KiloBytes\n   \t\t\t    M - MegaBytes\n   \t\t\t    G - GigaBytes\n   \t\t\t    T - TeraBytes\n   \t\t\t    P - PetaBytes\n   \t\t\t The default value is self adjusted. If the factor \n   \t\t\t is too big only 0s will be displayed\n";
    private static String sourceName;
    private static String destinationName;
    private static AtomicLong bytesNo;
    private static int BUFF_NO;
    private static int BUFF_SIZE;
    private static int COUNT;
    private static boolean verbose;
    private static long delay;
    private static long reportingFactor;
    private static Thread reportingThread;
    private static AtomicBoolean hasToRun;
    private static String wrFlags;
    private static long START_TIME;

    private static final String format(double number, long factor, String append) {
        String appendUM;
        double fNo = number;
        if (factor == 0L) {
            if (number > 1.125899906842624E15) {
                fNo /= 1.125899906842624E15;
                appendUM = "P" + append;
            } else if (number > 1.099511627776E12) {
                fNo /= 1.099511627776E12;
                appendUM = "T" + append;
            } else if (number > 1.073741824E9) {
                fNo /= 1.073741824E9;
                appendUM = "G" + append;
            } else if (number > 1048576.0) {
                fNo /= 1048576.0;
                appendUM = "M" + append;
            } else if (number > 1024.0) {
                fNo /= 1024.0;
                appendUM = "K" + append;
            } else {
                appendUM = append;
            }
        } else if (factor == 0x4000000000000L) {
            fNo /= 1.125899906842624E15;
            appendUM = "P" + append;
        } else if (factor == 0x10000000000L) {
            fNo /= 1.099511627776E12;
            appendUM = "T" + append;
        } else if (factor == 0x40000000L) {
            fNo /= 1.073741824E9;
            appendUM = "G" + append;
        } else if (factor == 0x100000L) {
            fNo /= 1048576.0;
            appendUM = "M" + append;
        } else if (factor == 1024L) {
            fNo /= 1024.0;
            appendUM = "K" + append;
        } else {
            appendUM = append;
        }
        return DecimalFormat.getNumberInstance().format(fNo) + " " + appendUM;
    }

    private static final void printHelp() {
        System.out.println(USAGE_MESSAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            int i;
            for (i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("-h")) continue;
                DDCopy.printHelp();
                System.exit(0);
            }
            for (i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("-v")) continue;
                verbose = true;
                break;
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i].startsWith("if=")) {
                    sourceName = args[i].substring("if=".length());
                    continue;
                }
                if (args[i].startsWith("of=")) {
                    destinationName = args[i].substring("of=".length());
                    continue;
                }
                if (args[i].startsWith("bs=")) {
                    String bSParam = args[i].substring("bs=".length());
                    int factor = 1;
                    try {
                        if (bSParam.endsWith("k") || bSParam.endsWith("K")) {
                            factor = 1024;
                            bSParam = bSParam.substring(0, bSParam.length() - 1);
                        } else if (bSParam.endsWith("m") || bSParam.endsWith("M")) {
                            factor = 0x100000;
                            bSParam = bSParam.substring(0, bSParam.length() - 1);
                        }
                        BUFF_SIZE = Integer.parseInt(bSParam) * factor;
                    }
                    catch (Throwable t) {
                        if (verbose) {
                            System.err.println("Cannot parse bsParam " + args[i] + " Cause: ");
                            t.printStackTrace();
                        } else {
                            System.err.println("Cannot parse bs param: " + args[i] + " . Try to run DDCopy with -v for further details");
                        }
                        DDCopy.printHelp();
                        System.err.flush();
                        System.out.flush();
                        System.exit(1);
                    }
                    continue;
                }
                if (args[i].startsWith("bn=")) {
                    try {
                        BUFF_NO = Integer.parseInt(args[i].substring("bn=".length()));
                    }
                    catch (Throwable t) {
                        BUFF_NO = 1;
                        if (verbose) {
                            System.err.println("Cannot parse bn param " + args[i] + " Cause: ");
                            t.printStackTrace();
                            continue;
                        }
                        System.err.println("Cannot parse bn param " + args[i] + ". Will use the default value: " + BUFF_NO);
                    }
                    continue;
                }
                if (args[i].startsWith("count=")) {
                    try {
                        COUNT = Integer.parseInt(args[i].substring("count=".length()));
                    }
                    catch (Throwable t) {
                        COUNT = -1;
                        if (verbose) {
                            System.err.println("Cannot parse count param " + args[i] + " Cause: ");
                            t.printStackTrace();
                            continue;
                        }
                        System.err.println("Cannot parse count param " + args[i] + ". Will use the default value: " + COUNT);
                    }
                    continue;
                }
                if (args[i].startsWith("statsdelay=")) {
                    try {
                        delay = Long.parseLong(args[i].substring("count=".length())) * 1000L;
                    }
                    catch (Throwable t) {
                        delay = 2000L;
                        if (verbose) {
                            System.err.println("Cannot parse statsdelay param " + args[i] + " Cause: ");
                            t.printStackTrace();
                            continue;
                        }
                        System.err.println("Cannot parse statsdelay param " + args[i] + ". Will use the default value: " + delay / 1000L + " seconds");
                    }
                    continue;
                }
                if (args[i].startsWith("flags=")) {
                    String wFlag = args[i].substring("flags=".length());
                    if (wFlag.equalsIgnoreCase("NOSYNC")) {
                        wrFlags = "rw";
                        continue;
                    }
                    if (wFlag.equalsIgnoreCase("SYNC")) {
                        wrFlags = "rws";
                        continue;
                    }
                    if (!wFlag.equalsIgnoreCase("DSYNC")) continue;
                    wrFlags = "rwd";
                    continue;
                }
                if (!args[i].startsWith("rformat=")) continue;
                String rFlag = args[i].substring("rformat=".length());
                if (rFlag.equalsIgnoreCase("K")) {
                    reportingFactor = 1024L;
                    continue;
                }
                if (rFlag.equalsIgnoreCase("M")) {
                    reportingFactor = 0x100000L;
                    continue;
                }
                if (rFlag.equalsIgnoreCase("G")) {
                    reportingFactor = 0x40000000L;
                    continue;
                }
                if (rFlag.equalsIgnoreCase("T")) {
                    reportingFactor = 0x10000000000L;
                    continue;
                }
                if (!rFlag.equalsIgnoreCase("P")) continue;
                reportingFactor = 0x4000000000000L;
            }
            if (sourceName == null || sourceName.trim().length() == 0) {
                System.out.println("\n No source specified ( if=<SourceFile> parameter ). Use -h for help.\n");
                System.exit(1);
            }
            if (destinationName == null || destinationName.trim().length() == 0) {
                System.out.println("\n No destination specified ( 'of=<DestinationFile>' parameter ). Use -h for help.\n");
                System.exit(1);
            }
            if (verbose) {
                StringBuilder sb = new StringBuilder();
                sb.append("Source: ").append(sourceName);
                sb.append(" Destination: ").append(destinationName);
                sb.append("");
            }
            FileChannel sourceChannel = new RandomAccessFile(sourceName, "r").getChannel();
            FileChannel destinationChannel = new RandomAccessFile(destinationName, wrFlags).getChannel();
            ByteBuffer[] bbuff = new ByteBuffer[BUFF_NO];
            for (int i2 = 0; i2 < BUFF_NO; ++i2) {
                try {
                    bbuff[i2] = ByteBuffer.allocateDirect(BUFF_SIZE);
                    continue;
                }
                catch (OutOfMemoryError oomError) {
                    System.err.println("ByteBuffer reached max limit. The copy may be slow. You may consider to increase to -XX:MaxDirectMemorySize=256m, or decrease the buffer number (bn) parameter");
                    System.err.flush();
                    System.exit(1);
                }
            }
            if (delay > 0L) {
                reportingThread = new ReportingThread();
                reportingThread.start();
            }
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            long count = 0L;
            START_TIME = System.currentTimeMillis();
            for (int j = 0; COUNT <= 0 || j < COUNT; ++j) {
                int i3;
                count = sourceChannel.read(bbuff);
                if (count == -1L) {
                    break;
                }
                for (i3 = 0; i3 < BUFF_NO; ++i3) {
                    bbuff[i3].flip();
                }
                count = BUFF_NO == 1 ? (long)destinationChannel.write(bbuff[0]) : destinationChannel.write(bbuff);
                if (verbose) {
                    System.out.println("Current transfer count =  " + count + " Total: " + bytesNo.get());
                }
                if (count < 0L) {
                    break;
                }
                bytesNo.addAndGet(count);
                for (i3 = 0; i3 < BUFF_NO; ++i3) {
                    bbuff[i3].clear();
                }
            }
        }
        catch (Throwable t) {
            System.err.println("Got exception: ");
            t.printStackTrace();
        }
        finally {
            System.out.flush();
            System.err.flush();
        }
    }

    static {
        bytesNo = new AtomicLong(0L);
        BUFF_NO = 1;
        BUFF_SIZE = 4096;
        COUNT = 0;
        verbose = false;
        delay = 2000L;
        reportingFactor = 0L;
        hasToRun = new AtomicBoolean(true);
        wrFlags = "rw";
    }

    private static final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            this.setName("Shutdown Hook Thread");
            if (verbose) {
                System.out.println("\n\n Entering shutdown hook \n\n");
            }
            hasToRun.set(false);
            if (reportingThread != null) {
                reportingThread.interrupt();
            }
            long totalTime = System.currentTimeMillis() - START_TIME;
            long totalBytes = bytesNo.get();
            double avgSpeed = (double)totalBytes / ((double)totalTime / 1000.0);
            System.out.println("\n\n Total Transfer: " + DDCopy.format(totalBytes, reportingFactor, "Bytes") + " ( " + totalBytes + " bytes )\n Time: " + totalTime / 1000L + " seconds\n Avg Speed: " + DDCopy.format(avgSpeed, reportingFactor, "B/s") + "\n");
            System.out.flush();
            System.err.flush();
        }
    }

    private static final class ReportingThread
    extends Thread {
        long lastTime;
        long lastCount;
        long now;
        long cCount;

        public ReportingThread() {
            this.setDaemon(true);
            this.setName("DDCopy reporting thread");
        }

        @Override
        public void run() {
            this.lastCount = bytesNo.get();
            this.lastTime = System.currentTimeMillis();
            while (true) {
                try {
                    Thread.sleep(delay);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!hasToRun.get()) {
                    return;
                }
                this.now = System.currentTimeMillis();
                this.cCount = bytesNo.get();
                double speed = (double)(this.cCount - this.lastCount) / ((double)(this.now - this.lastTime) / 1000.0);
                double avgSpeed = (double)this.cCount / ((double)(this.now - START_TIME) / 1000.0);
                this.lastTime = this.now;
                this.lastCount = this.cCount;
                System.out.println("[" + new Date().toString() + "] Current Speed = " + DDCopy.format(speed, reportingFactor, "B/s") + " Avg Speed: " + DDCopy.format(avgSpeed, reportingFactor, "B/s") + " Total Transfer: " + DDCopy.format(this.cCount, reportingFactor, "B"));
            }
        }
    }
}

