/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.FDTBuffer;

public class FDTBufferPool {
    private static final transient Logger logger = Logger.getLogger(FDTBufferPool.class.getName());
    public static AtomicInteger POOL_SIZE;
    public static FDTBufferPool _theInstance;
    private static int BUFFER_SIZE;
    private static volatile boolean initialized;
    final Lock lock = new ReentrantLock();
    final Condition notTaking = this.lock.newCondition();
    final Condition notEmpty = this.lock.newCondition();
    private final LinkedList<ByteBuffer> buffersPool = new LinkedList();
    private final LinkedList<FDTBuffer> fdtBuffersPool = new LinkedList();
    private volatile boolean taking = false;
    private volatile boolean limitReached = false;

    private FDTBufferPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final FDTBufferPool getInstance() {
        if (initialized) return _theInstance;
        Class<FDTBufferPool> clazz = FDTBufferPool.class;
        synchronized (FDTBufferPool.class) {
            while (!initialized) {
                try {
                    FDTBufferPool.class.wait();
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, " Got exception waiting for initialization ", t);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _theInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean initInstance(int buffSize) {
        Class<FDTBufferPool> clazz = FDTBufferPool.class;
        synchronized (FDTBufferPool.class) {
            if (!initialized) {
                BUFFER_SIZE = buffSize;
                _theInstance = new FDTBufferPool();
                initialized = true;
                FDTBufferPool.class.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    private ByteBuffer tryAllocateBuffer() {
        if (!this.limitReached) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(BUFFER_SIZE);
                return byteBuffer;
            }
            catch (OutOfMemoryError oom) {
                logger.log(Level.INFO, " ByteBuffer reached max limit. You may consider to increase to -XX:MaxDirectMemorySize=256m ");
                this.limitReached = true;
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " Got general exception trying to allocate the mem. Please notify the developers! ", t);
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            finally {
                if (!this.limitReached) {
                    POOL_SIZE.incrementAndGet();
                }
            }
        }
        return null;
    }

    public int getBufferSize() {
        return BUFFER_SIZE;
    }

    public int getSize() {
        return this.buffersPool.size();
    }

    public int getCapacity() {
        return POOL_SIZE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FDTBuffer take(int size) throws InterruptedException {
        FDTBuffer fdtBuffer = null;
        ByteBuffer[] buffs = null;
        int allocated = 0;
        int reminder = size % BUFFER_SIZE;
        int buffCount = size < BUFFER_SIZE ? 1 : size / BUFFER_SIZE + (reminder != 0 ? 1 : 0);
        this.lock.lock();
        try {
            while (this.taking) {
                this.notTaking.await();
            }
            this.taking = true;
            fdtBuffer = this.fdtBuffersPool.poll();
            if (fdtBuffer == null) {
                fdtBuffer = new FDTBuffer();
            }
            buffs = new ByteBuffer[buffCount];
            while (allocated < buffCount) {
                ByteBuffer buff = this.buffersPool.poll();
                if (buff == null && !this.limitReached) {
                    buff = this.tryAllocateBuffer();
                }
                if (buff == null) {
                    while (this.buffersPool.size() == 0) {
                        this.notEmpty.await();
                    }
                    buff = this.buffersPool.poll();
                }
                buffs[allocated++] = buff;
            }
            if (reminder != 0) {
                buffs[buffCount - 1].limit(reminder);
            }
            fdtBuffer.setBuffer(buffs);
        }
        finally {
            if (fdtBuffer == null || fdtBuffer.get() == null) {
                int i;
                try {
                    if (fdtBuffer.get() != null) {
                        fdtBuffer.free();
                        this.fdtBuffersPool.offer(fdtBuffer);
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, " Got exception returning fdtBuffer to the pull", t);
                }
                try {
                    for (i = 0; i < allocated; ++i) {
                        this.buffersPool.add(buffs[i]);
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, " Got exception returning buffers to the pull [ currentIdx = " + i + " allocated = " + allocated + " buffCount = " + buffCount + " ]", t);
                }
            }
            try {
                this.taking = false;
                this.notTaking.signal();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " \n\n Got exception signaling notTaking Condition. Something has gone dreadfully wrong \n\n", t);
            }
            this.lock.unlock();
        }
        return fdtBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(FDTBuffer fdtBuffer) {
        this.lock.lock();
        try {
            if (fdtBuffer.free()) {
                ByteBuffer[] buffs = fdtBuffer.get();
                for (int i = 0; i < buffs.length; ++i) {
                    this.buffersPool.add(buffs[i]);
                }
                this.fdtBuffersPool.add(fdtBuffer);
            }
        }
        finally {
            if (this.buffersPool.size() != 0) {
                this.notEmpty.signal();
            }
            this.lock.unlock();
        }
        return true;
    }

    static {
        initialized = false;
    }
}

