/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import lia.util.net.common.InetNetwork;

public class NetMatcher {
    private ArrayList<InetNetwork> networks;

    public NetMatcher() {
    }

    public NetMatcher(String[] nets) {
        this.initInetNetworks(nets);
    }

    public NetMatcher(Collection nets) {
        this.initInetNetworks(nets);
    }

    public void initInetNetworks(Collection<String> nets) {
        this.networks = new ArrayList();
        for (String netName : nets) {
            try {
                InetNetwork net = InetNetwork.getFromString(netName);
                if (this.networks.contains(net)) continue;
                this.networks.add(net);
            }
            catch (UnknownHostException uhe) {
                this.log("Cannot resolve address: " + uhe.getMessage());
            }
        }
        this.networks.trimToSize();
    }

    public void initInetNetworks(String[] nets) {
        this.networks = new ArrayList();
        for (int i = 0; i < nets.length; ++i) {
            try {
                InetNetwork net = InetNetwork.getFromString(nets[i]);
                if (this.networks.contains(net)) continue;
                this.networks.add(net);
                continue;
            }
            catch (UnknownHostException uhe) {
                this.log("Cannot resolve address: " + uhe.getMessage());
            }
        }
        this.networks.trimToSize();
    }

    public boolean matchInetNetwork(String hostIP) {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(hostIP);
        }
        catch (UnknownHostException uhe) {
            this.log("Cannot resolve address for " + hostIP + ": " + uhe.getMessage());
        }
        boolean sameNet = false;
        if (ip != null) {
            Iterator<InetNetwork> iter = this.networks.iterator();
            while (!sameNet && iter.hasNext()) {
                InetNetwork network = iter.next();
                sameNet = network.contains(ip);
            }
        }
        return sameNet;
    }

    public boolean matchInetNetwork(InetAddress ip) {
        boolean sameNet = false;
        Iterator<InetNetwork> iter = this.networks.iterator();
        while (!sameNet && iter.hasNext()) {
            InetNetwork network = iter.next();
            sameNet = network.contains(ip);
        }
        return sameNet;
    }

    public String toString() {
        return this.networks.toString();
    }

    protected void log(String s) {
    }
}

