/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.gsi.FDTGSIServer;
import lia.util.net.common.AbstractFDTCloseable;
import lia.util.net.common.AcceptableTask;
import lia.util.net.common.Config;
import lia.util.net.common.NetMatcher;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTSessionManager;

public class FDTServer
extends AbstractFDTCloseable {
    private static final Logger logger = Logger.getLogger(FDTServer.class.getName());
    private static final Config config = Config.getInstance();
    private static final FDTSessionManager fdtSessionManager = FDTSessionManager.getInstance();
    final ServerSocketChannel ssc;
    final ServerSocket ss;
    final Selector sel;
    final ExecutorService executor;
    final AtomicBoolean hasToRun = new AtomicBoolean(true);
    UUID fdtSessionID;

    public FDTServer(int port) throws Exception {
        this.executor = Utils.getStandardExecService("[ Acceptable ServersThreadPool ] ", 5, 10, new ArrayBlockingQueue<Runnable>(65500), 3);
        this.ssc = ServerSocketChannel.open();
        this.ssc.configureBlocking(false);
        this.ss = this.ssc.socket();
        String listenIP = config.getListenAddress();
        if (listenIP == null) {
            this.ss.bind(new InetSocketAddress(port));
        } else {
            this.ss.bind(new InetSocketAddress(InetAddress.getByName(listenIP), port));
        }
        this.sel = Selector.open();
        this.ssc.register(this.sel, 16);
        if (config.isGSIModeEnabled()) {
            FDTGSIServer gsiServer = new FDTGSIServer(config.getGSIPort());
            gsiServer.start();
            logger.log(Level.INFO, "FDT started in GSI mode on port: " + config.getGSIPort());
        }
        ScheduledThreadPoolExecutor monitoringService = Utils.getMonitoringExecService();
        monitoringService.scheduleWithFixedDelay(new FDTServerMonitorTask(), 10L, 10L, TimeUnit.SECONDS);
        System.out.println("READY");
    }

    public static final boolean filterSourceAddress(Socket socket) {
        NetMatcher filter = config.getSourceAddressFilter();
        if (filter != null) {
            logger.info("Enforcing source address filter: " + filter);
            String sourceIPAddress = socket.getInetAddress().getHostAddress();
            if (!filter.matchInetNetwork(sourceIPAddress)) {
                Utils.closeIgnoringExceptions(socket);
                logger.warning(" Client [" + sourceIPAddress + "] is not allowed to transfer. Socket closed!");
                return false;
            }
        }
        return true;
    }

    public static final void main(String[] args) throws Exception {
        FDTServer jncs = new FDTServer(config.getPort());
        jncs.doWork();
    }

    public boolean stopServer() {
        return this.hasToRun.compareAndSet(true, false);
    }

    public UUID getFdtSessionID() {
        return this.fdtSessionID;
    }

    /*
     * Unable to fully structure code
     */
    public void doWork() throws Exception {
        Thread.currentThread().setName(" FDTServer - Main loop worker ");
        FDTServer.logger.info("FDTServer start listening on port: " + this.ss.getLocalPort());
        isStandAlone = FDTServer.config.isStandAlone();
        try {
            block9: while (true) {
                if (!isStandAlone) {
                    if (FDTServer.fdtSessionManager.isInited() && FDTServer.fdtSessionManager.sessionsNumber() == 0) {
                        FDTServer.logger.log(Level.INFO, "FDTServer will finish. No more sessions to serve.");
                        return;
                    }
                } else if (!this.hasToRun.get() && FDTServer.fdtSessionManager.isInited() && FDTServer.fdtSessionManager.sessionsNumber() == 0) {
                    FDTServer.logger.log(Level.INFO, "FDTServer will finish. No more sessions to serve.");
                    return;
                }
                count = this.sel.select(2000L);
                if (count == 0) continue;
                it = this.sel.selectedKeys().iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block9;
                    sk = it.next();
                    it.remove();
                    if (!sk.isValid() || !sk.isAcceptable()) continue;
                    ssc = (ServerSocketChannel)sk.channel();
                    sc = ssc.accept();
                    try {
                        this.executor.execute(new AcceptableTask(sc));
                    }
                    catch (Throwable t) {
                        sb = new StringBuilder();
                        sb.append("[ FDTServer ] got exception in while sumbiting the AcceptableTask for SocketChannel: ").append(sc);
                        if (sc != null) {
                            sb.append(" Socket: ").append(sc.socket());
                        }
                        sb.append(" Cause: ");
                        FDTServer.logger.log(Level.WARNING, sb.toString(), t);
                    }
                }
                break;
            }
            catch (Throwable t) {
                FDTServer.logger.log(Level.WARNING, "[FDTServer] Exception in main loop!", t);
                throw new Exception(t);
            }
        }
        finally {
            FDTServer.logger.log(Level.INFO, "[FDTServer] main loop FINISHED!");
            Utils.closeIgnoringExceptions(this.ssc);
            Utils.closeIgnoringExceptions(this.sel);
            Utils.closeIgnoringExceptions(this.ss);
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
    }

    public void run() {
        try {
            this.doWork();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "[ FDTServer ] exception main loop", t);
            this.close("[ FDTServer ] exception main loop", t);
        }
        this.close(null, null);
        logger.info(" \n\n FDTServer finishes @ " + new Date().toString() + "!\n\n");
    }

    @Override
    protected void internalClose() {
    }

    static final class FDTServerMonitorTask
    implements Runnable {
        FDTServerMonitorTask() {
        }

        @Override
        public void run() {
        }
    }
}

