/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.FileChannelProvider;
import lia.util.net.common.MonitoringUtils;
import lia.util.net.common.NetloggerRecord;
import lia.util.net.common.StoragePathDecoder;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FDTSessionManager;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.FileBlockConsumer;
import lia.util.net.copy.FileSession;
import lia.util.net.copy.FileWriterSession;
import lia.util.net.copy.disk.DiskWriterManager;
import lia.util.net.copy.disk.ResumeManager;
import lia.util.net.copy.filters.Postprocessor;
import lia.util.net.copy.filters.Preprocessor;
import lia.util.net.copy.filters.ProcessorInfo;
import lia.util.net.copy.transport.ControlChannel;
import lia.util.net.copy.transport.CtrlMsg;
import lia.util.net.copy.transport.FDTProcolException;
import lia.util.net.copy.transport.FDTSessionConfigMsg;
import lia.util.net.copy.transport.TCPSessionReader;

public class FDTWriterSession
extends FDTSession
implements FileBlockConsumer {
    private static final Logger logger = Logger.getLogger(FDTWriterSession.class.getName());
    private static final ResumeManager resumeManager = ResumeManager.getInstance();
    private static final Config config = Config.getInstance();
    private static final DiskWriterManager dwm = DiskWriterManager.getInstance();
    private final AtomicBoolean finalCleaupExecuted = new AtomicBoolean(false);
    private final AtomicBoolean finishNotifiedExecuted = new AtomicBoolean(false);
    private String destinationDir;
    private String[] fileList;
    private ProcessorInfo processorInfo;

    public FDTWriterSession(int transferPort) throws Exception {
        super((short)1, transferPort);
        Utils.initLogger(config.getLogLevel(), new File("/tmp/" + this.sessionID + ".log"), new Properties());
        dwm.addSession(this);
        this.sendInitConf();
        this.monID = config.getMonID();
    }

    public FDTWriterSession(ControlChannel cc) throws Exception {
        super(cc, (short)0);
        Utils.initLogger(config.getLogLevel(), new File("/tmp/" + this.sessionID + ".log"), new Properties());
        dwm.addSession(this);
        this.monID = (String)cc.remoteConf.get("-monID");
    }

    public void setControlChannel(ControlChannel controlChannel) {
        this.controlChannel = controlChannel;
    }

    public void notifyWriterDown(int partitionID) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[FDTWriterSession] writer down for partition: " + partitionID);
        }
    }

    private void notifySessionFinished() {
        if (this.finishNotifiedExecuted.compareAndSet(false, true)) {
            StringBuilder downNotif;
            block8: {
                downNotif = null;
                try {
                    if (this.downMessage() != null && this.downCause() != null) {
                        downNotif = new StringBuilder();
                        if (this.downMessage() != null) {
                            downNotif.append("Down message: ").append(this.downMessage()).append("\n");
                        }
                        if (this.downCause() != null) {
                            downNotif.append("Down cause:\n").append(Utils.getStackTrace(this.downCause())).append("\n");
                        }
                    }
                }
                catch (Throwable t1) {
                    if (!logger.isLoggable(Level.FINE)) break block8;
                    logger.log(Level.FINE, "[ FDTWriterSession ] [ notifySessionFinished ]  Got exception building the remote notify message", t1);
                }
            }
            try {
                this.controlChannel.sendCtrlMessage(new CtrlMsg(10, downNotif == null ? null : downNotif.toString()));
            }
            catch (Throwable t1) {
                logger.log(Level.WARNING, " [ FDTWriterSession ] [ notifySessionFinished ] got exception sending END_SESSION message", t1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void finalCleanup() {
        block48: {
            if (this.finalCleaupExecuted.compareAndSet(false, true)) {
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    isFinest = FDTWriterSession.logger.isLoggable(Level.FINEST);
                                    isFiner = isFinest != false || FDTWriterSession.logger.isLoggable(Level.FINER) != false;
                                    v0 = isFine = isFiner != false || FDTWriterSession.logger.isLoggable(Level.FINE) != false;
                                    if (isFiner) {
                                        FDTWriterSession.logger.log(Level.FINER, "\n\n [ FDTWriterSession ] [ finalCleanup ] STARTED \n\n ");
                                    }
                                    endDate = new Date();
                                    nlrec = new NetloggerRecord();
                                    nlrec.setBlock(DirectByteBufferPool.getInstance().getBufferSize());
                                    nlrec.setBuffer(Math.max(0, FDTWriterSession.config.getSockBufSize()));
                                    if (this.downCause() == null && this.downMessage() == null) {
                                        nlrec.setCode("226");
                                    } else {
                                        nlrec.setCode("426");
                                    }
                                    nlrec.setCompleted(endDate);
                                    nlrec.setDestination(this.controlChannel.remoteAddress);
                                    try {
                                        nlrec.setHost(InetAddress.getLocalHost());
                                    }
                                    catch (UnknownHostException var6_6) {
                                        // empty catch block
                                    }
                                    nlrec.setNbytes(this.getTotalBytes());
                                    nlrec.setStart(new Date(this.startTimeMillis));
                                    if (this.getTransportProvider() != null) {
                                        nlrec.setStreams(this.getTransportProvider().getNumberOfStreams());
                                    }
                                    nlrec.setType("STOR");
                                    FDTWriterSession.logger.info(nlrec.toULMString());
                                    try {
                                        this.notifySessionFinished();
                                    }
                                    catch (Throwable ignore) {
                                        if (!isFinest) break block43;
                                        FDTWriterSession.logger.log(Level.FINEST, "[ FDTWriterSession ] [ finalCleanup ] exception notify session finished. Cause:", ignore);
                                    }
                                }
                                try {
                                    sb = new StringBuilder();
                                    sb.append("\n\nFDTWriterSession ( ").append(this.sessionID);
                                    if (this.monID != null) {
                                        sb.append(" / ").append(this.monID);
                                    }
                                    sb.append(" ) final stats:");
                                    sb.append("\n Started: ").append(new Date(this.startTimeMillis));
                                    sb.append("\n Ended:   ").append(endDate);
                                    period = System.nanoTime() - this.startTimeNanos;
                                    sb.append("\n Transfer period:   ").append(Utils.getETA(TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.startTimeNanos)));
                                    sb.append("\n TotalBytes: ").append(this.getTotalBytes());
                                    utilBytes = 0L;
                                    if (this.transportProvider != null) {
                                        utilBytes = this.transportProvider.getUtilBytes();
                                        sb.append("\n TotalNetworkBytes: ").append(this.transportProvider.getUtilBytes());
                                        try {
                                            if (Utils.updateTotalReadCounter(this.transportProvider.getUtilBytes()) || !FDTWriterSession.logger.isLoggable(Level.FINEST)) ** GOTO lbl72
                                            FDTWriterSession.logger.log(Level.FINEST, " [ FDTWriterSession ] Unable to update the contor in the update file.");
                                        }
                                        catch (Throwable tu) {
                                            if (!FDTWriterSession.logger.isLoggable(Level.FINEST)) ** GOTO lbl72
                                            FDTWriterSession.logger.log(Level.FINEST, " [ FDTWriterSession ] Unable to update the contor in the update file. Cause: ", tu);
                                        }
                                        finally {
                                            this.transportProvider.close(this.downMessage(), this.downCause());
                                        }
                                    } else {
                                        sb.append("\n TotalNetworkBytes: 0");
                                    }
lbl72:
                                    // 5 sources

                                    sb.append("\n Exit Status: ").append(this.downCause() == null && this.downMessage() == null ? "OK" : "Not OK");
                                    sb.append("\n");
                                    if (this.customLog) {
                                        FDTWriterSession.logger.info(sb.toString());
                                    } else {
                                        System.out.println(sb.toString());
                                    }
                                    if (FDTWriterSession.config.getMonitor().equals("OPENTSDB")) {
                                        monUtils = new MonitoringUtils(FDTWriterSession.config, this);
                                        monUtils.monitorEndStats(this.downCause() == null && this.downMessage() == null, this.getTotalBytes(), utilBytes, this.startTimeMillis, endDate.getTime(), period, "Writers");
                                    }
                                }
                                catch (Throwable t) {
                                    FDTWriterSession.logger.log(Level.WARNING, "[ FDTWriterSession ] [ finalCleanup ] [ HANDLED ] Exception getting final statistics. Smth went wrong! Cause: ", t);
                                }
                                try {
                                    if (FDTWriterSession.dwm.removeSession(this, this.downMessage(), this.downCause())) {
                                        if (isFine) {
                                            FDTWriterSession.logger.log(Level.FINE, "[ FDTWriterSession ] [ finalCleanup ] Successfully removing session from DiskWriterManager");
                                        }
                                    } else if (isFine) {
                                        FDTWriterSession.logger.log(Level.FINE, "[ FDTWriterSession ] [ finalCleanup ] Removing session from DiskWriterManager returned FALSE should have been true!!");
                                    }
                                }
                                catch (Throwable fine) {
                                    if (!isFine) break block44;
                                    FDTWriterSession.logger.log(Level.FINE, "[ FDTWriterSession ] [ finalCleanup ] exception removing session. Cause:", fine);
                                }
                            }
                            try {
                                for (FileSession fileSession : this.fileSessions.values()) {
                                    try {
                                        fileSession.close(this.downMessage(), this.downCause());
                                    }
                                    catch (Throwable ign) {
                                        if (!isFinest) continue;
                                        FDTWriterSession.logger.log(Level.FINEST, "[ FDTWriterSession ] [ finalCleanup ]  closing file session: " + fileSession + " got exception. Cause: ", ign);
                                    }
                                }
                            }
                            catch (Throwable ignOutter) {
                                if (!isFinest) break block45;
                                FDTWriterSession.logger.log(Level.FINEST, "[ FDTWriterSession ] [ finalCleanup ]  closing file sessions got exception. Cause: ", ignOutter);
                            }
                        }
                        try {
                            this.doPostProcessing();
                        }
                        catch (Throwable t1) {
                            FDTWriterSession.logger.log(Level.WARNING, "[ FDTWriterSession ] [ finalCleanup  Got exception in postProcessing", t1);
                        }
                        try {
                            if (this.transportProvider != null) {
                                this.transportProvider.close(this.downMessage(), this.downCause());
                            }
                        }
                        catch (Throwable ignTransport) {
                            if (!isFinest) break block46;
                            FDTWriterSession.logger.log(Level.FINEST, "[ FDTWriterSession ] [ finalCleanup ]  closing transport got exception. Cause: ", ignTransport);
                        }
                    }
                    try {
                        if (this.controlChannel != null) {
                            this.controlChannel.close(this.downMessage(), this.downCause());
                        }
                    }
                    catch (Throwable ignCtrl) {
                        if (!isFinest) break block47;
                        FDTWriterSession.logger.log(Level.FINEST, "[ FDTWriterSession ] [ finalCleanup ]  closing control channel got exception. Cause: ", ignCtrl);
                    }
                }
                try {
                    FDTSessionManager.getInstance().finishSession(this.sessionID, this.downMessage(), this.downCause());
                }
                catch (Throwable ignore) {
                    if (!isFinest) break block48;
                    FDTWriterSession.logger.log(Level.FINEST, "[ FDTWriterSession ] [ finalCleanup ]  finishing session in session manager got exception. Cause: ", ignore);
                }
            }
        }
    }

    @Override
    protected void internalClose() throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            Thread.dumpStack();
            logger.log(Level.FINEST, " [ FDTWriterSession ] enters internalClose downMsg: " + this.downMessage() + " ,  downCause: " + this.downCause());
            Thread.dumpStack();
        }
        try {
            super.internalClose();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, " [ FDTWriterSession ] [ HANDLED ] internalClose exception in base class.", t);
        }
        String downMessage = this.downMessage();
        Throwable downCause = this.downCause();
        if (downMessage == null && downCause == null) {
            this.checkFinished(null);
        } else {
            String downLogMsg = downMessage == null ? "N/A" : downMessage;
            logger.log(Level.INFO, "\nThe FDTWriterSession ( " + this.sessionID + " ) finished with error(s). Cause: " + downLogMsg, this.downCause());
            this.finalCleanup();
        }
    }

    private void sendInitConf() throws Exception {
        FDTSessionConfigMsg sccm = new FDTSessionConfigMsg();
        sccm.destinationDir = config.getDestinationDir();
        sccm.fileLists = config.getFileList();
        sccm.remappedFileLists = config.getRemappedFileList();
        sccm.recursive = config.isRecursive();
        this.destinationDir = sccm.destinationDir;
        this.controlChannel.sendCtrlMessage(new CtrlMsg(6, sccm));
        this.setCurrentState(2);
    }

    private void sendFinishedSessions() throws Exception {
        this.controlChannel.sendCtrlMessage(new CtrlMsg(7, this.finishedSessions.toArray(new UUID[this.finishedSessions.size()])));
        this.setCurrentState(8);
    }

    @Override
    public void handleInitFDTSessionConf(CtrlMsg ctrlMsg) throws Exception {
        logger.log(Level.WARNING, "[ FDTWriterSession ] handleInitFDTSessionConf must not be called on the writer side. Msg: " + ctrlMsg);
        FDTProcolException fpe = new FDTProcolException("Illegal message INIT_FDT_CONF in WriterSesssion");
        fpe.fillInStackTrace();
        throw fpe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleFinalFDTSessionConf(CtrlMsg ctrlMsg) throws Exception {
        boolean isFiner = logger.isLoggable(Level.FINER);
        config.registerTransferPortForSession(this.controlChannel.localPort, this.sessionID().toString());
        FDTSessionConfigMsg sccm = (FDTSessionConfigMsg)ctrlMsg.message;
        this.destinationDir = sccm.destinationDir;
        StoragePathDecoder spd = new StoragePathDecoder(sccm.destinationDir, "", "");
        if (spd.hasStorageInfo()) {
            if (config.storageParams() == null) {
                logger.log(Level.SEVERE, "Unable to transfer to storage: Storage configuration is not found.");
            } else {
                this.destinationDir = config.storageParams().localFileDir();
                logger.log(Level.WARNING, "Destination directory has been changed from " + sccm.destinationDir + " to " + this.destinationDir);
            }
        }
        this.fileList = new String[sccm.fileLists.length];
        System.arraycopy(sccm.fileLists, 0, this.fileList, 0, this.fileList.length);
        boolean shouldReplace = false;
        char remoteCharSeparator = ((String)this.controlChannel.remoteConf.get("file.separator")).charAt(0);
        if (File.separatorChar == '/' && remoteCharSeparator == '\\') {
            shouldReplace = true;
        }
        int fCount = sccm.fileIDs.length;
        boolean noTmp = false;
        if (config.isNoTmpFlagSet() || this.controlChannel.remoteConf.get("-notmp") != null) {
            noTmp = true;
        }
        boolean noLock = false;
        if (config.isNoLockFlagSet() || this.controlChannel.remoteConf.get("-nolock") != null || this.controlChannel.remoteConf.get("-nolocks") != null) {
            noLock = true;
        }
        FileChannelProvider fcp = Config.getInstance().getFileChannelProviderFactory().newWriterFileChannelProvider(this);
        String preProcessFiltersProp = config.getPreFilters();
        boolean hasPreProc = false;
        String[] preProcessFilters = null;
        if (preProcessFiltersProp == null || preProcessFiltersProp.length() == 0) {
            if (isFiner) {
                logger.log(Level.FINE, "[ FDTWriterSession ] No FDT Preprocess Filters defined");
            }
        } else {
            preProcessFilters = preProcessFiltersProp.split(",");
            if (preProcessFilters == null || preProcessFilters.length == 0) {
                logger.log(Level.WARNING, "Illegal -preFilters parameter");
            } else {
                hasPreProc = true;
            }
        }
        HashMap<String, FileSession> preProcMap = hasPreProc ? new HashMap<String, FileSession>() : null;
        for (int i = 0; i < fCount; ++i) {
            String fName = sccm.remappedFileLists == null || sccm.remappedFileLists[i] == null ? sccm.fileLists[i] : sccm.remappedFileLists[i];
            FileWriterSession fws = new FileWriterSession(sccm.fileIDs[i], this, this.destinationDir + File.separator + (shouldReplace ? fName.replace(remoteCharSeparator, File.separatorChar) : fName), sccm.fileSizes[i], sccm.lastModifTimes[i], this.isLoop, this.writeMode, noTmp, noLock, fcp);
            this.fileSessions.put(fws.sessionID, fws);
            if (hasPreProc) {
                FileWriterSession fwsCopy = FileWriterSession.fromFileWriterSession(fws);
                preProcMap.put(fwsCopy.fileName(), fwsCopy);
            }
            this.setSessionSize(this.sessionSize() + fws.sessionSize());
        }
        if (hasPreProc) {
            long sTime = System.nanoTime();
            boolean bPreProccessing = false;
            try {
                bPreProccessing = this.doPreprocess(preProcessFilters, preProcMap);
            }
            catch (Throwable tPrepProcess) {
                logger.log(Level.WARNING, "Got exception preprocessing", tPrepProcess);
            }
            if (bPreProccessing) {
                logger.log(Level.INFO, "Preprocessing took: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - sTime) + " ms.");
            }
        }
        for (FileSession fws : this.fileSessions.values()) {
            if (resumeManager.isFinished(fws)) {
                if (isFiner) {
                    logger.log(Level.FINER, "\n\n\n ====> [ FDTWriterSession ] the file session " + fws.sessionID + " is Finished!");
                }
                this.addAndGetUtilBytes(fws.sessionSize());
                this.addAndGetTotalBytes(fws.sessionSize());
                super.finishFileSession(fws.sessionID, null);
                continue;
            }
            if (!isFiner) continue;
            logger.log(Level.FINER, "\n\n\n ====> [ FDTWriterSession ] <====== the file session " + fws.sessionID + " is NOT Finished!  <============ ");
        }
        this.buildPartitionMap();
        this.sendFinishedSessions();
        if (this.role == 0) {
            if (this.transportProvider != null) throw new FDTProcolException(" Non null transport provider !");
            this.transportProvider = new TCPSessionReader((FDTSession)this, this);
        } else if (this.role == 1) {
            this.transportProvider = new TCPSessionReader((FDTSession)this, this, InetAddress.getByName(config.getHostName()), this.transferPort, config.getSockNum());
        }
        logger.log(Level.FINER, "FWS handleFinalFDTSessionConf starting session on port: " + this.transferPort);
        this.controlChannel.sendCtrlMessage(new CtrlMsg(9, this.transferPort));
        this.setCurrentState(32);
        this.checkFinished(null);
    }

    @Override
    public long getSize() {
        return this.sessionSize();
    }

    @Override
    public void handleStartFDTSession(CtrlMsg ctrlMsg) throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "[ FDTWriterSession ] handleStartFDTSession. Msg: " + ctrlMsg);
        }
        if (this.role == 1 && this.transportProvider == null) {
            this.transportProvider = new TCPSessionReader((FDTSession)this, this, InetAddress.getByName(config.getHostName()), this.transferPort, config.getSockNum());
        }
        if (config.getMonitor().equals("OPENTSDB")) {
            MonitoringUtils monUtils = new MonitoringUtils(config, this);
            monUtils.monitorStart(System.currentTimeMillis(), "Writers");
        }
        this.setCurrentState(128);
        this.transportProvider.startTransport(true);
    }

    @Override
    public void handleEndFDTSession(CtrlMsg ctrlMsg) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\n\n\n\n\n\n ---------------- [ FDTWriterSession ] handleEndFDTSession. Msg: " + ctrlMsg.message);
        }
        String remoteDownMsg = null;
        if (ctrlMsg.message != null) {
            if (ctrlMsg.message instanceof Map) {
                logger.log(Level.INFO, "[ FDTWriterSession ] Remote FDTReaderSession for session [ " + this.sessionID + " ] finished ok. Waiting for our side to finish.");
                Map md5Sums = (Map)ctrlMsg.message;
                if (md5Sums != null && md5Sums.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n\n===\tRemote MD5 Sums\t===");
                    for (Map.Entry entry : md5Sums.entrySet()) {
                        sb.append("\n").append(Utils.md5ToString((byte[])entry.getValue())).append("  ").append(((FileSession)this.fileSessions.get(entry.getKey())).fileName());
                    }
                    sb.append("\n===\tEND Remote MD5 Sums\t=== \n");
                    logger.log(Level.INFO, sb.toString());
                }
            } else if (ctrlMsg.message instanceof String) {
                remoteDownMsg = (String)ctrlMsg.message;
                this.close(remoteDownMsg, null);
                logger.log(Level.WARNING, "\n\n [ FDTWriterSession ] Remote FDTReaderSession for session [ " + this.sessionID + " ] finished with errors:\n" + remoteDownMsg + "\n");
            }
        } else {
            logger.log(Level.INFO, "[ FDTWriterSession ] Remote FDTReaderSession for session [ " + this.sessionID + " ] finished ok. Waiting for our side to finish.");
        }
    }

    private boolean doPreprocess(String[] preProcessFilters, Map<String, FileSession> preProcMap) throws Exception {
        UUID fid;
        boolean bFinishedSessions;
        boolean isFine;
        boolean isFinest = logger.isLoggable(Level.FINEST);
        boolean isFiner = isFinest || logger.isLoggable(Level.FINER);
        boolean bl = isFine = isFiner || logger.isLoggable(Level.FINE);
        if (isFinest) {
            logger.log(Level.FINEST, "[ FDTWriterSession ] entering preprocessing started");
        }
        ProcessorInfo processorInfo = new ProcessorInfo();
        processorInfo.destinationDir = this.destinationDir == null ? config.getDestinationDir() : this.destinationDir;
        Set finishedSessions = this.finishedSessions;
        boolean bl2 = bFinishedSessions = finishedSessions.size() > 0;
        if (bFinishedSessions) {
            for (FileSession fileSession : preProcMap.values()) {
                UUID id = fileSession.sessionID();
                if (!finishedSessions.contains(id)) continue;
                String fName = fileSession.fileName();
                if (isFinest) {
                    logger.log(Level.FINEST, "[FDTWriterSession] [doPreprocess] finished file session: " + fName);
                }
                preProcMap.remove(fName);
            }
        }
        String[] fList = preProcMap.keySet().toArray(new String[preProcMap.size()]);
        processorInfo.fileList = fList;
        processorInfo.fileSessionMap = preProcMap;
        processorInfo.remoteAddress = this.controlChannel.remoteAddress;
        processorInfo.remotePort = this.controlChannel.remotePort;
        for (String filterName : preProcessFilters) {
            Preprocessor preprocessor = (Preprocessor)Class.forName(filterName).newInstance();
            preprocessor.preProcessFileList(processorInfo, this.controlChannel.subject);
        }
        this.processorInfo = processorInfo;
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (FileSession fs : preProcMap.values()) {
            fid = fs.sessionID;
            FileSession existing = (FileSession)this.fileSessions.get(fid);
            if (existing == null) {
                logger.log(Level.WARNING, "[FDTWriterSession] [doPreprocess] new file session from filter will be ingored: " + fs);
                continue;
            }
            if (fs instanceof FileWriterSession) {
                hashSet.add(fid);
                this.fileSessions.put(fid, fs);
                continue;
            }
            logger.log(Level.WARNING, "[FDTWriterSession] [doPreprocess] new file session from filter will be ingored: " + fs + " because is not a FileWriterSession");
        }
        for (FileSession fws : this.fileSessions.values()) {
            fid = fws.sessionID;
            if (hashSet.contains(fid)) continue;
            if (isFine) {
                logger.log(Level.FINE, "\n\n\n ====> [ FDTWriterSession ] [preProcess] the file session " + fws.sessionID + "/" + fws.fileName() + " is finished!");
            }
            this.addAndGetUtilBytes(fws.sessionSize());
            this.addAndGetTotalBytes(fws.sessionSize());
            super.finishFileSession(fws.sessionID, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPostProcessing() throws Exception {
        if (!this.postProcessingDone.compareAndSet(false, true)) {
            return false;
        }
        int filtersCount = 0;
        long sTime = System.nanoTime();
        logger.log(Level.INFO, "[ FDTWriterSession ] Post Processing started");
        try {
            ProcessorInfo processorInfo = this.processorInfo == null ? new ProcessorInfo() : this.processorInfo;
            HashMap<String, FileSession> preprocMap = new HashMap<String, FileSession>();
            String postProcessFiltersProp = config.getPostFilters();
            if (postProcessFiltersProp == null || postProcessFiltersProp.length() == 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.INFO, " [ FDTWriterSession ] No FDT Postprocess Filters defined");
                }
            } else {
                String[] postProcessFilters = postProcessFiltersProp.split(",");
                if (postProcessFilters == null || postProcessFilters.length == 0) {
                    logger.log(Level.WARNING, "Cannot understand -postFilters");
                } else {
                    filtersCount = postProcessFilters.length;
                    for (FileSession fws : this.fileSessions.values()) {
                        preprocMap.put(fws.fileName(), fws);
                    }
                    String[] fList = preprocMap.keySet().toArray(new String[preprocMap.size()]);
                    processorInfo.fileList = fList;
                    processorInfo.fileSessionMap = new HashMap<String, FileSession>(preprocMap);
                    processorInfo.destinationDir = this.destinationDir;
                    System.arraycopy(this.fileList, 0, processorInfo.fileList, 0, this.fileList.length);
                    processorInfo.remoteAddress = this.controlChannel.remoteAddress;
                    processorInfo.remotePort = this.controlChannel.remotePort;
                    for (String filterName : postProcessFilters) {
                        this.postPprocess(processorInfo, filterName);
                    }
                }
            }
        }
        finally {
            StringBuffer sb = new StringBuffer();
            if (filtersCount > 0) {
                sb.append("[ FDTWriterSession ] Postprocessing: ").append(filtersCount).append(" filters in ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - sTime)).append(" ms");
            } else {
                sb.append("[ FDTWriterSession ] No post processing filters defined/processed.");
            }
            logger.log(Level.INFO, sb.toString());
        }
        return filtersCount > 0;
    }

    private void postPprocess(ProcessorInfo processorInfo, String filterName) throws Exception {
        boolean searchElsewhere = false;
        Postprocessor postprocessor = null;
        try {
            postprocessor = (Postprocessor)Class.forName("lia.util.net.copy.filters.examples." + filterName).newInstance();
        }
        catch (ClassNotFoundException e) {
            searchElsewhere = true;
        }
        if (searchElsewhere) {
            String userDirectory = System.getProperty("user.dir");
            File filter = new File(userDirectory + File.separator + "plugins" + File.separator);
            logger.log(Level.FINER, "Trying to load plugin from 'plugins' directory. " + filter.toString());
            try {
                URL url = filter.toURL();
                URL[] urls = new URL[]{url};
                URLClassLoader cl = new URLClassLoader(urls);
                Class<?> cls = cl.loadClass(filterName);
                postprocessor = (Postprocessor)cls.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.FINER, "Failed to load filter from external plugins directory. " + e);
                postprocessor = (Postprocessor)Class.forName(filterName).newInstance();
            }
        }
        if (postprocessor != null) {
            postprocessor.postProcessFileList(processorInfo, this.controlChannel.subject, this.downCause(), this.downMessage());
        }
    }

    private void checkFinished(Throwable finishCause) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "\n\n\n\n\n\n ---------------- [ FDTWriterSession ] finishedSessions.size(). " + this.finishedSessions.size() + " fileSessions.size() " + this.fileSessions.size());
        }
        if (this.finishedSessions.size() == this.fileSessions.size()) {
            if (this.downMessage() != null || this.downCause() != null) {
                this.close(this.downMessage(), this.downCause());
            } else {
                this.close(this.downMessage(), finishCause);
            }
            this.notifySessionFinished();
            Runnable finalR = new Runnable(){

                @Override
                public void run() {
                    FDTWriterSession.this.finalCleanup();
                }
            };
            Utils.getMonitoringExecService().schedule(finalR, 5L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void finishFileSession(UUID sessionID, Throwable finishCause) {
        super.finishFileSession(sessionID, finishCause);
        this.checkFinished(finishCause);
    }

    @Override
    public boolean offer(FileBlock fileBlock, long delay, TimeUnit unit) throws InterruptedException {
        if (this.isClosed()) {
            return false;
        }
        FileSession fs = (FileSession)this.fileSessions.get(fileBlock.fileSessionID);
        if (fs != null) {
            return dwm.offerFileBlock(fileBlock, fs.partitionID(), delay, unit);
        }
        logger.log(Level.WARNING, "No such fileSession: " + fileBlock.fileSessionID + " in my session map");
        return false;
    }

    @Override
    public void put(FileBlock fileBlock) throws InterruptedException {
        if (this.isClosed()) {
            throw new InterruptedException("Session is closed");
        }
        FileSession fs = (FileSession)this.fileSessions.get(fileBlock.fileSessionID);
        if (fs != null) {
            dwm.putFileBlock(fileBlock, fs.partitionID());
        } else {
            logger.log(Level.SEVERE, "No such fileSession: " + fileBlock.fileSessionID + " in my session map");
        }
    }
}

