/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.util.UUID;
import lia.util.net.common.AbstractFDTCloseable;

public abstract class IOSession
extends AbstractFDTCloseable {
    public final long startTimeMillis;
    public final long startTimeNanos;
    protected final UUID sessionID;
    protected volatile long sessionSize;

    public IOSession() {
        this(UUID.randomUUID());
    }

    public IOSession(UUID sessionID) {
        if (sessionID == null) {
            throw new NullPointerException("Null session ID");
        }
        this.sessionID = sessionID;
        this.startTimeMillis = System.currentTimeMillis();
        this.startTimeNanos = System.nanoTime();
    }

    public IOSession(UUID sessionID, long sessionSize) {
        this(sessionID);
        this.sessionSize = sessionSize;
    }

    public UUID sessionID() {
        return this.sessionID;
    }

    public long sessionSize() {
        return this.sessionSize;
    }

    public void setSessionSize(long sessionSize) {
        this.sessionSize = sessionSize;
    }
}

