/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.base;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.copy.Accountable;

public abstract class AbstractAccountableMonitoringTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(AbstractAccountableMonitoringTask.class.getName());
    private final ConcurrentHashMap<Accountable, AccountableEntry> accMap = new ConcurrentHashMap();

    public AbstractAccountableMonitoringTask(Accountable[] accountableList) {
        if (accountableList == null) {
            return;
        }
        int pos = 0;
        for (Accountable accountable : accountableList) {
            try {
                this.addIfAbsent(accountable);
                ++pos;
            }
            catch (NullPointerException npe) {
                throw new NullPointerException(" accountable is null on pos: " + pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void iComputeRate(Accountable accountable, AccountableEntry accEntry, long now) {
        try {
            if (accEntry.debug) {
                logger.log(Level.INFO, " AbstractAccountableMonitoringTask debug for : " + accountable + " BEFORE: \n:" + accEntry);
            }
            accEntry.currentUtilBytes = accountable.getUtilBytes();
            accEntry.currentTotalBytes = accountable.getTotalBytes();
            if (accEntry.lastTimeCalled != 0L) {
                this.computeRate(accEntry, now);
            }
            if (accEntry.debug) {
                logger.log(Level.INFO, " AbstractAccountableMonitoringTask debug for : " + accountable + " AFTER: \n:" + accEntry);
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, " [ AbstractAccountableMonitoringTask ] got exception computing rate for " + accountable, t);
        }
        finally {
            if (accEntry.lastTimeCalled == 0L) {
                accEntry.startTime = now;
                accEntry.startUtilBytes = accEntry.currentUtilBytes;
                accEntry.startTotalBytes = accEntry.currentTotalBytes;
            }
            accEntry.lastTimeCalled = now;
            accEntry.lastUtilBytes = accEntry.currentUtilBytes;
            accEntry.lastTotalBytes = accEntry.currentTotalBytes;
        }
    }

    @Override
    public void run() {
        long now = System.nanoTime();
        try {
            for (Map.Entry<Accountable, AccountableEntry> entry : this.accMap.entrySet()) {
                this.iComputeRate(entry.getKey(), entry.getValue(), now);
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, " [ AbstractAccountableMonitoringTask ] got exception main loop ", t);
        }
        try {
            this.rateComputed();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, " [ AbstractAccountableMonitoringTask ] calling rateComputed", t);
        }
    }

    public abstract void rateComputed();

    protected void resetAllCounters() {
        for (AccountableEntry accEntry : this.accMap.values()) {
            accEntry.lastTimeCalled = 0L;
            accEntry.startTime = 0L;
            accEntry.startTotalBytes = 0L;
            accEntry.lastTotalBytes = 0L;
            accEntry.startUtilBytes = 0L;
            accEntry.lastUtilBytes = 0L;
            accEntry.totalRate = 0.0;
            accEntry.utilRate = 0.0;
            accEntry.avgTotalRate = 0.0;
            accEntry.avgUtilRate = 0.0;
        }
    }

    protected void resetAllCounters(Accountable accountable) {
        AccountableEntry accEntry = this.getEntry(accountable);
        accEntry.lastTimeCalled = 0L;
        accEntry.startTime = 0L;
        accEntry.startTotalBytes = 0L;
        accEntry.lastTotalBytes = 0L;
        accEntry.startUtilBytes = 0L;
        accEntry.lastUtilBytes = 0L;
        accEntry.totalRate = 0.0;
        accEntry.utilRate = 0.0;
        accEntry.avgTotalRate = 0.0;
        accEntry.avgUtilRate = 0.0;
    }

    private void computeRate(AccountableEntry accEntry, long now) throws Exception {
        long dt = TimeUnit.NANOSECONDS.toMillis(now - accEntry.lastTimeCalled);
        ++accEntry.monCount;
        if (dt <= 0L) {
            logger.log(Level.WARNING, "[ " + this.getClass() + " ] Timing issues detected on the system. lastTime: " + accEntry.lastTimeCalled + "ns now: " + now + "ns. The average and instant rates will be reseted.");
            accEntry.startTime = now;
            accEntry.startUtilBytes = accEntry.currentUtilBytes;
            accEntry.startTotalBytes = accEntry.currentTotalBytes;
            return;
        }
        accEntry.utilRate = (double)(accEntry.currentUtilBytes - accEntry.lastUtilBytes) * 1000.0 / (double)dt;
        accEntry.totalRate = (double)(accEntry.currentTotalBytes - accEntry.lastTotalBytes) * 1000.0 / (double)dt;
        dt = TimeUnit.NANOSECONDS.toMillis(now - accEntry.startTime);
        if (dt <= 0L) {
            logger.log(Level.WARNING, "[ " + this.getClass() + " ] Timing issues detected on the system. lastTime: " + accEntry.startTime + "ns now: " + now + "ns. The average and instant rates will be reseted.");
            accEntry.startTime = now;
            accEntry.startUtilBytes = accEntry.currentUtilBytes;
            accEntry.startTotalBytes = accEntry.currentTotalBytes;
            return;
        }
        accEntry.avgUtilRate = (double)(accEntry.currentUtilBytes - accEntry.startUtilBytes) * 1000.0 / (double)dt;
        accEntry.avgTotalRate = (double)(accEntry.currentTotalBytes - accEntry.startTotalBytes) * 1000.0 / (double)dt;
    }

    protected double getUtilRate(Accountable accountable) {
        return this.getEntry((Accountable)accountable).utilRate;
    }

    protected double getTotalRate(Accountable accountable) {
        return this.getEntry((Accountable)accountable).totalRate;
    }

    protected double getAvgTotalRate(Accountable accountable) {
        return this.getEntry((Accountable)accountable).avgTotalRate;
    }

    protected double getAvgUtilRate(Accountable accountable) {
        return this.getEntry((Accountable)accountable).avgUtilRate;
    }

    protected long getMonCount(Accountable accountable) {
        return this.getEntry((Accountable)accountable).monCount;
    }

    private AccountableEntry getEntry(Accountable accountable) {
        AccountableEntry accEntry = this.accMap.get(accountable);
        if (accEntry == null) {
            throw new NoSuchElementException("No entry for " + accountable);
        }
        return accEntry;
    }

    protected boolean addIfAbsent(Accountable accountable) {
        if (accountable == null) {
            throw new NullPointerException(" Accountable cannot be null ");
        }
        return this.accMap.putIfAbsent(accountable, new AccountableEntry()) == null;
    }

    protected boolean addIfAbsent(Accountable accountable, boolean debug) {
        boolean bRet;
        AccountableEntry accEntry = new AccountableEntry(debug);
        boolean bl = bRet = this.accMap.putIfAbsent(accountable, accEntry) == null;
        if (bRet) {
            this.iComputeRate(accountable, accEntry, System.nanoTime());
        }
        return bRet;
    }

    protected boolean remove(Accountable accountable) {
        return this.accMap.remove(accountable) != null;
    }

    private static class AccountableEntry {
        final boolean debug;
        protected long startTime;
        protected long lastTimeCalled;
        protected long lastUtilBytes;
        protected long currentUtilBytes;
        protected long lastTotalBytes;
        protected long currentTotalBytes;
        protected long startUtilBytes;
        protected long startTotalBytes;
        protected double utilRate;
        protected double totalRate;
        protected double avgUtilRate;
        protected double avgTotalRate;
        long monCount;

        AccountableEntry() {
            this(false);
        }

        AccountableEntry(boolean debug) {
            this.debug = debug;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" startTimeMillis: ").append(this.startTime).append(", ");
            sb.append(" startUtilBytes: ").append(this.startUtilBytes).append(", ");
            sb.append(" startTotalBytes: ").append(this.startTotalBytes).append(", ");
            sb.append(" lastTimeCalled: ").append(this.lastTimeCalled).append(", ");
            sb.append(" lastUtilBytes: ").append(this.lastUtilBytes).append(", ");
            sb.append(" currentUtilBytes: ").append(this.currentUtilBytes).append(", ");
            sb.append(" lastTotalBytes: ").append(this.lastTotalBytes).append(", ");
            sb.append(" currentTotalBytes: ").append(this.currentTotalBytes).append(", ");
            sb.append(" utilRate: ").append(this.utilRate).append(", ");
            sb.append(" totalRate: ").append(this.totalRate).append(", ");
            sb.append(" avgUtilRate: ").append(this.avgUtilRate).append(", ");
            sb.append(" avgUtilRate: ").append(this.avgUtilRate);
            return sb.toString();
        }
    }
}

