/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa;

import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.monitoring.lisa.LISAReportingTask;
import lia.util.net.copy.monitoring.lisa.LisaCtrlNotifier;

public class CmdCheckerTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(CmdCheckerTask.class.getName());
    private final FDTSession fdtSession;
    private final LISAReportingTask lisaReportingTask;
    private final LisaCtrlNotifier notifier;
    private String cmdToSend;

    public CmdCheckerTask(FDTSession fdtSession, LISAReportingTask lrt, LisaCtrlNotifier notifier) {
        this.fdtSession = fdtSession;
        this.lisaReportingTask = lrt;
        this.notifier = notifier;
    }

    @Override
    public void run() {
        if (this.cmdToSend == null) {
            this.cmdToSend = "exec FDTClientController getControlParams " + this.fdtSession.getMonID();
            logger.log(Level.INFO, "[ CmdCheckerTask ] LISA/ML remote command checker started with sessionID: " + this.fdtSession.getMonID());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "[ CmdCheckerTask ] LISA/ML remote command checker for sessionID: " + this.fdtSession.getMonID() + " running");
        }
        try {
            String response = this.lisaReportingTask.lisaMon.sendDirectCommand(this.cmdToSend);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "[ CmdCheckerTask ] for sessionID: " + this.fdtSession.getMonID() + " received: " + response);
            }
            if (response != null) {
                this.notifier.notifyLisaCtrlMsg(response);
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "[ CmdCheckerTask ] Exception in main loop ", t);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINER, "[ CmdCheckerTask ] LISA/ML remote command checker for sessionID: " + this.fdtSession.getMonID() + " finished");
        }
    }
}

