/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lia.util.net.common.HeaderBufferPool;
import lia.util.net.common.Utils;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.transport.FDTKeyAttachement;
import lia.util.net.copy.transport.internal.FDTSelectionKey;

class FDTWriterKeyAttachement
extends FDTKeyAttachement
implements Comparable<FDTWriterKeyAttachement> {
    private static final HeaderBufferPool hbp = Utils.getHeaderBufferPool();
    private static AtomicLong SEQ = new AtomicLong(0L);
    final AtomicLong lastOperation = new AtomicLong(0L);
    final AtomicBoolean connectCookieSent;
    volatile int payloadSize;
    FileBlock fileBlock;

    public FDTWriterKeyAttachement(FDTSelectionKey fdtSelectionKey, boolean useFixedSizeBlocks, boolean connectCookieSent) {
        super(fdtSelectionKey, useFixedSizeBlocks);
        this.connectCookieSent = new AtomicBoolean(connectCookieSent);
    }

    public static final boolean fromFileBlock(FileBlock fileBlock, FDTWriterKeyAttachement wsa) throws InterruptedException {
        if (fileBlock == null) {
            return false;
        }
        wsa.recycleBuffers();
        ByteBuffer header = hbp.take();
        if (header == null) {
            return false;
        }
        long seq = SEQ.getAndIncrement();
        header.putInt(2);
        header.putInt(1);
        header.putInt(56);
        header.putInt(fileBlock.buff.limit());
        header.putLong(0L);
        header.putLong(seq);
        header.putLong(fileBlock.fileSessionID.getMostSignificantBits()).putLong(fileBlock.fileSessionID.getLeastSignificantBits());
        header.putLong(fileBlock.fileOffset);
        header.flip();
        if (wsa.useFixedSizeBlocks) {
            fileBlock.buff.limit(fileBlock.buff.capacity());
        }
        wsa.setBuffers(header, fileBlock.buff);
        wsa.payloadSize = fileBlock.buff.limit();
        wsa.setBuffers(header, fileBlock.buff);
        return true;
    }

    public synchronized boolean isHeaderWritten() {
        return !this.header().hasRemaining();
    }

    public synchronized boolean isPayloadWritten() {
        return this.payload().position() >= this.payloadSize;
    }

    public final void updateLastOperation() {
        this.lastOperation.set(System.nanoTime());
    }

    @Override
    public int compareTo(FDTWriterKeyAttachement o) {
        if (this == o) {
            return 0;
        }
        long diff = this.lastOperation.get() - o.lastOperation.get();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        if (this.seq < o.seq) {
            return -1;
        }
        return 1;
    }
}

