/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.Iterator;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthenticatedData;
import org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.bouncycastle.cms.MacOutputStream;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedDataGenerator() {
    }

    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(cMSTypedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        Object object;
        Object object22;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object22 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add((DEREncodable)((Object)object22.generate(macCalculator.getKey())));
        }
        if (digestCalculator != null) {
            DEROctetString dEROctetString;
            Object object3;
            BERConstructedOctetString bERConstructedOctetString;
            Object object4;
            try {
                object22 = new ByteArrayOutputStream();
                object4 = new TeeOutputStream(digestCalculator.getOutputStream(), (OutputStream)object22);
                cMSTypedData.write((OutputStream)object4);
                ((OutputStream)object4).close();
                bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object22).toByteArray());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform digest calculation: " + iOException.getMessage(), iOException);
            }
            object22 = this.getBaseParameters(cMSTypedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest());
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            object4 = new DERSet(this.authGen.getAttributes(Collections.unmodifiableMap(object22)).toASN1EncodableVector());
            try {
                object3 = macCalculator.getOutputStream();
                ((OutputStream)object3).write(object4.getDEREncoded());
                ((OutputStream)object3).close();
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("exception decoding algorithm parameters.", iOException);
            }
            object3 = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.unmodifiableMap(object22)).toASN1EncodableVector()) : null;
            ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.data, (DEREncodable)((Object)bERConstructedOctetString));
            object = new AuthenticatedData(null, new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), contentInfo, (ASN1Set)object4, dEROctetString, (ASN1Set)object3);
        } else {
            DEROctetString dEROctetString;
            BERConstructedOctetString bERConstructedOctetString;
            Object object5;
            try {
                object22 = new ByteArrayOutputStream();
                object5 = new TeeOutputStream((OutputStream)object22, macCalculator.getOutputStream());
                cMSTypedData.write((OutputStream)object5);
                ((OutputStream)object5).close();
                bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object22).toByteArray());
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("exception decoding algorithm parameters.", iOException);
            }
            object22 = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.EMPTY_MAP).toASN1EncodableVector()) : null;
            object5 = new ContentInfo(CMSObjectIdentifiers.data, (DEREncodable)((Object)bERConstructedOctetString));
            object = new AuthenticatedData(null, new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), null, (ContentInfo)object5, null, dEROctetString, (ASN1Set)object22);
        }
        object22 = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (DEREncodable)object);
        return new CMSAuthenticatedData((ContentInfo)object22, new DigestCalculatorProvider(){

            @Override
            public DigestCalculator get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }

    public CMSAuthenticatedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    private CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, KeyGenerator keyGenerator, Provider provider) throws NoSuchAlgorithmException, CMSException {
        DEROctetString dEROctetString;
        BERConstructedOctetString bERConstructedOctetString;
        Object object;
        AlgorithmIdentifier algorithmIdentifier;
        Object object22;
        SecretKey secretKey;
        Provider provider2 = keyGenerator.getProvider();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            Iterator iterator = CMSEnvelopedHelper.INSTANCE.getMac(string, provider2);
            secretKey = keyGenerator.generateKey();
            object22 = this.generateParameterSpec(string, secretKey, provider2);
            ((Mac)((Object)iterator)).init(secretKey, (AlgorithmParameterSpec)object22);
            algorithmIdentifier = this.getAlgorithmIdentifier(string, (AlgorithmParameterSpec)object22, provider2);
            object = new ByteArrayOutputStream();
            TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)object, new MacOutputStream((Mac)((Object)iterator)));
            cMSProcessable.write(teeOutputStream);
            ((OutputStream)teeOutputStream).close();
            ((ByteArrayOutputStream)object).close();
            bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object).toByteArray());
            dEROctetString = new DEROctetString(((Mac)((Object)iterator)).doFinal());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("exception setting up parameters.", invalidParameterSpecException);
        }
        for (Object object22 : this.oldRecipientInfoGenerators) {
            try {
                aSN1EncodableVector.add((DEREncodable)((Object)object22.generate(secretKey, this.rand, provider)));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        for (Object object22 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add((DEREncodable)((Object)object22.generate(new GenericKey(secretKey))));
        }
        object22 = new ContentInfo(CMSObjectIdentifiers.data, (DEREncodable)((Object)bERConstructedOctetString));
        object = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (DEREncodable)((Object)new AuthenticatedData(null, new DERSet(aSN1EncodableVector), algorithmIdentifier, null, (ContentInfo)object22, null, dEROctetString, null)));
        return new CMSAuthenticatedData((ContentInfo)object);
    }

    public CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string, CMSUtils.getProvider(string2));
    }

    public CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, provider);
    }
}

