/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataSink;
import org.globus.ftp.dc.AbstractDataChannel;
import org.globus.ftp.dc.EBlockImageDCReader;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.LocalReply;
import org.globus.ftp.dc.ManagedSocketBox;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.SocketPool;
import org.globus.ftp.dc.TransferSinkThread;
import org.globus.ftp.dc.TransferThreadManager;
import org.globus.ftp.vanilla.BasicServerControlChannel;

public class GridFTPTransferSinkThread
extends TransferSinkThread {
    protected static Log logger = LogFactory.getLog(GridFTPTransferSinkThread.class.getName());
    protected EBlockParallelTransferContext eContext;

    public GridFTPTransferSinkThread(AbstractDataChannel dataChannel, SocketBox socketBox, DataSink sink, BasicServerControlChannel localControlChannel, EBlockParallelTransferContext context) throws Exception {
        super(dataChannel, socketBox, sink, localControlChannel, context);
        this.eContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        TransferThreadManager threadManager = this.eContext.getTransferThreadManager();
        threadManager.transferThreadStarting();
        BasicServerControlChannel basicServerControlChannel = this.localControlChannel;
        synchronized (basicServerControlChannel) {
            if (this.localControlChannel.getReplyCount() == 0) {
                this.localControlChannel.write(new LocalReply(125));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(Object quitToken) throws IOException {
        block12: {
            SocketPool pool = ((EBlockParallelTransferContext)this.context).getSocketPool();
            try {
                if (((ManagedSocketBox)this.socketBox).isReusable()) {
                    if (!((EBlockImageDCReader)this.reader).willCloseReceived()) {
                        logger.debug("shutdown; leaving the socket open");
                        pool.checkIn(this.socketBox);
                        break block12;
                    }
                    logger.debug("shutdown; closing the socket");
                    try {
                        this.reader.close();
                        break block12;
                    }
                    finally {
                        pool.remove(this.socketBox);
                        this.socketBox.setSocket(null);
                    }
                }
                logger.debug("shutdown; closing the socket");
                try {
                    this.reader.close();
                }
                finally {
                    pool.remove(this.socketBox);
                    this.socketBox.setSocket(null);
                }
            }
            finally {
                TransferThreadManager threadManager = this.eContext.getTransferThreadManager();
                threadManager.transferThreadTerminating();
                if (quitToken != null) {
                    this.sink.close();
                }
            }
        }
    }
}

