/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.provider.simple;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.X509Name;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.provider.SigningPolicyStoreException;

public class SimpleMemorySigningPolicyStore
implements SigningPolicyStore {
    private static Log logger = LogFactory.getLog(SimpleMemorySigningPolicyStore.class);
    private Map<String, SigningPolicy> store = new ConcurrentHashMap<String, SigningPolicy>();

    public SimpleMemorySigningPolicyStore(SigningPolicy[] policies) {
        int numPolicies = 0;
        if (policies != null) {
            numPolicies = policies.length;
            for (SigningPolicy policy : policies) {
                if (policy == null) continue;
                X509Name name = new X509Name(false, policy.getCASubjectDN().getName("RFC2253"));
                this.store.put(X509NameHelper.toString(name), policy);
                logger.debug("Adding to policy store: " + X509NameHelper.toString(name));
            }
        }
        logger.debug("Loaded " + this.store.size() + " policies of " + numPolicies);
    }

    public SigningPolicy getSigningPolicy(X500Principal caPrincipal) throws SigningPolicyStoreException {
        SigningPolicy policy = this.store.get(caPrincipal.getName("RFC2253"));
        if (policy == null) {
            X509Name name = new X509Name(false, caPrincipal.getName("RFC2253"));
            logger.debug("Getting from policy store: " + X509NameHelper.toString(name));
            policy = this.store.get(X509NameHelper.toString(name));
        }
        return policy;
    }
}

