/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.IOException;
import java.io.OutputStream;
import org.globus.common.ChainedIOException;
import org.globus.ftp.FTPClient;
import org.globus.ftp.OutputStreamDataSource;
import org.globus.ftp.exception.FTPException;
import org.globus.ftp.vanilla.TransferState;
import org.globus.io.streams.GlobusOutputStream;

public class FTPOutputStream
extends GlobusOutputStream {
    protected OutputStream output;
    protected FTPClient ftp;
    protected TransferState state;

    protected FTPOutputStream() {
    }

    public FTPOutputStream(String host, int port, String user, String pwd, String file, boolean append) throws IOException, FTPException {
        this(host, port, user, pwd, file, append, true, 1);
    }

    public FTPOutputStream(String host, int port, String user, String pwd, String file, boolean append, boolean passive, int type) throws IOException, FTPException {
        this.ftp = new FTPClient(host, port);
        this.ftp.authorize(user, pwd);
        this.put(passive, type, file, append);
    }

    public void abort() {
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.ftp.close();
        }
        catch (IOException iOException) {
        }
        catch (FTPException fTPException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.state != null) {
                this.state.waitForEnd();
            }
        }
        catch (FTPException e) {
            throw new ChainedIOException("close failed.", e);
        }
        finally {
            try {
                this.ftp.close();
            }
            catch (FTPException ee) {
                throw new ChainedIOException("close failed.", ee);
            }
        }
    }

    protected void put(boolean passive, int type, String remoteFile, boolean append) throws IOException, FTPException {
        OutputStreamDataSource source = null;
        try {
            this.ftp.setType(type);
            if (passive) {
                this.ftp.setPassive();
                this.ftp.setLocalActive();
            } else {
                this.ftp.setLocalPassive();
                this.ftp.setActive();
            }
            source = new OutputStreamDataSource(2048);
            this.state = this.ftp.asynchPut(remoteFile, source, null, append);
            this.state.waitForStart();
            this.output = source.getOutputStream();
        }
        catch (FTPException e) {
            if (source != null) {
                source.close();
            }
            this.close();
            throw e;
        }
    }

    public void write(byte[] msg) throws IOException {
        this.output.write(msg);
    }

    public void write(byte[] msg, int from, int length) throws IOException {
        this.output.write(msg, from, length);
    }

    public void write(int b) throws IOException {
        this.output.write(b);
    }

    public void flush() throws IOException {
        this.output.flush();
    }
}

