/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.http.LineReader;

public abstract class HTTPParser {
    private static Log logger = LogFactory.getLog(HTTPParser.class.getName());
    protected String _server;
    protected String _host;
    protected String _contentType;
    protected String _connection;
    protected long _contentLength = -1L;
    protected boolean _chunked = false;
    protected LineReader _reader;

    public HTTPParser(InputStream is) throws IOException {
        this.setInputStream(is);
        this.parse();
    }

    public String getContentType() {
        return this._contentType;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public boolean isChunked() {
        return this._chunked;
    }

    public LineReader getReader() {
        return this._reader;
    }

    public void setInputStream(InputStream in) {
        this._reader = new LineReader(in);
    }

    public abstract void parseHead(String var1) throws IOException;

    protected void parse() throws IOException {
        String line = this._reader.readLine();
        if (logger.isTraceEnabled()) {
            logger.trace(line);
        }
        this.parseHead(line);
        while ((line = this._reader.readLine()).length() != 0) {
            if (logger.isTraceEnabled()) {
                logger.trace(line);
            }
            if (line.startsWith("Connection: ")) {
                this._connection = HTTPParser.getRest(line, "Connection: ".length());
                continue;
            }
            if (line.startsWith("Server: ")) {
                this._server = HTTPParser.getRest(line, "Server: ".length());
                continue;
            }
            if (line.startsWith("Content-Type: ")) {
                this._contentType = HTTPParser.getRest(line, "Content-Type: ".length());
                continue;
            }
            if (line.startsWith("Content-Length: ")) {
                this._contentLength = Long.parseLong(HTTPParser.getRest(line, "Content-Length: ".length()));
                continue;
            }
            if (line.startsWith("Host: ")) {
                this._host = HTTPParser.getRest(line, "Host: ".length());
                continue;
            }
            if (!line.startsWith("Transfer-Encoding: chunked")) continue;
            this._chunked = true;
        }
    }

    protected static final String getRest(String line, int index) {
        return line.substring(index).trim();
    }
}

