/*
 * Decompiled with CFR 0.152.
 */
package org.globusonline.transfer;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.globusonline.transfer.APIError;
import org.globusonline.transfer.BaseTransferAPIClient;
import org.globusonline.transfer.JSONTransferAPIClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Example {
    private JSONTransferAPIClient client;
    private static DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public Example(JSONTransferAPIClient jSONTransferAPIClient) {
        this.client = jSONTransferAPIClient;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java org.globusonline.transfer.Example username [certfile keyfile [baseurl]]]");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = null;
        if (stringArray.length > 1 && stringArray[1].length() > 0) {
            string2 = stringArray[1];
        }
        String string3 = null;
        if (stringArray.length > 2 && stringArray[2].length() > 0) {
            string3 = stringArray[2];
        }
        String string4 = null;
        if (stringArray.length > 3 && stringArray[3].length() > 0) {
            string4 = stringArray[3];
        }
        try {
            JSONTransferAPIClient jSONTransferAPIClient = new JSONTransferAPIClient(string, null, string2, string3, string4);
            System.out.println("base url: " + jSONTransferAPIClient.getBaseUrl());
            Example example = new Example(jSONTransferAPIClient);
            example.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run() throws IOException, JSONException, GeneralSecurityException, APIError {
        System.out.println("=== Before Transfer ===");
        this.displayTasksummary();
        this.displayTaskList(604800L);
        if (!this.autoActivate("go#ep1") || !this.autoActivate("go#ep2")) {
            System.err.println("Unable to auto activate go tutorial endpoints,  exiting");
            return;
        }
        this.displayLs("go#ep1", "~");
        this.displayLs("go#ep2", "~");
        JSONTransferAPIClient.Result result = this.client.getResult("/transfer/submission_id");
        String string = result.document.getString("value");
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("DATA_TYPE", "transfer");
        jSONObject.put("submission_id", string);
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("DATA_TYPE", "transfer_item");
        jSONObject2.put("source_endpoint", "go#ep1");
        jSONObject2.put("source_path", "~/.bashrc");
        jSONObject2.put("destination_endpoint", "go#ep2");
        jSONObject2.put("destination_path", "~/api-example-bashrc-copy");
        jSONObject.append("DATA", jSONObject2);
        result = this.client.postResult("/transfer", jSONObject, null);
        String string2 = result.document.getString("task_id");
        if (!this.waitForTask(string2, 120)) {
            System.out.println("Transfer not complete after 2 minutes, exiting");
            return;
        }
        System.out.println("=== After Transfer ===");
        this.displayTasksummary();
        this.displayLs("go#ep2", "~");
        System.out.println("=== Endpoint Management ===");
        String string3 = "example_copygoep1";
        String string4 = this.copyEndpoint("go#ep1", string3);
        System.out.println("copy go#ep1 to " + string3 + ": " + string4);
        string4 = this.setEndpointDescription(string3, "copy of go#ep1");
        System.out.println("endpoint update: " + string4);
        result = this.client.getResult(BaseTransferAPIClient.endpointPath(string3));
        System.out.println("description after update: " + result.document.getString("description"));
        string4 = this.deleteEndpoint(string3);
        System.out.println("endpoint delete: " + string4);
        try {
            result = this.client.getResult(BaseTransferAPIClient.endpointPath(string3));
        }
        catch (APIError aPIError) {
            System.out.println("get on deleted endpoint raised APIError: " + aPIError);
        }
    }

    public void displayTasksummary() throws IOException, JSONException, GeneralSecurityException, APIError {
        JSONTransferAPIClient.Result result = this.client.getResult("/tasksummary");
        System.out.println("Task Summary for " + this.client.getUsername() + ": ");
        Iterator iterator = result.document.sortedKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("DATA_TYPE")) continue;
            System.out.println("  " + string + ": " + result.document.getString(string));
        }
    }

    public void displayTaskList(long l) throws IOException, JSONException, GeneralSecurityException, APIError {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (l > 0L) {
            long l2 = System.currentTimeMillis() - 1000L * l;
            hashMap.put("filter", "request_time:" + isoDateFormat.format(new Date(l2)) + ",");
        }
        JSONTransferAPIClient.Result result = this.client.getResult("/task_list", hashMap);
        int n = result.document.getInt("length");
        if (n == 0) {
            System.out.println("No tasks were submitted in the last " + l + " seconds");
            return;
        }
        JSONArray jSONArray = result.document.getJSONArray("DATA");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            System.out.println("Task " + jSONObject.getString("task_id") + ":");
            Example.displayTask(jSONObject);
        }
    }

    private static void displayTask(JSONObject jSONObject) throws JSONException {
        Iterator iterator = jSONObject.sortedKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("DATA_TYPE") || string.equals("LINKS") || string.endsWith("_link")) continue;
            System.out.println("  " + string + ": " + jSONObject.getString(string));
        }
    }

    public boolean autoActivate(String string) throws IOException, JSONException, GeneralSecurityException, APIError {
        String string2 = BaseTransferAPIClient.endpointPath(string) + "/autoactivate";
        JSONTransferAPIClient.Result result = this.client.postResult(string2, null, null);
        String string3 = result.document.getString("code");
        return !string3.startsWith("AutoActivationFailed");
    }

    public void displayLs(String string, String string2) throws IOException, JSONException, GeneralSecurityException, APIError {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string2 != null) {
            hashMap.put("path", string2);
        }
        String string3 = BaseTransferAPIClient.endpointPath(string) + "/ls";
        JSONTransferAPIClient.Result result = this.client.getResult(string3, hashMap);
        System.out.println("Contents of " + string2 + " on " + string + ":");
        JSONArray jSONArray = result.document.getJSONArray("DATA");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            System.out.println("  " + jSONObject.getString("name"));
            Iterator iterator = jSONObject.sortedKeys();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (string4.equals("DATA_TYPE") || string4.equals("LINKS") || string4.endsWith("_link") || string4.equals("name")) continue;
                System.out.println("    " + string4 + ": " + jSONObject.getString(string4));
            }
        }
    }

    public boolean waitForTask(String string, int n) throws IOException, JSONException, GeneralSecurityException, APIError {
        String string2 = "ACTIVE";
        String string3 = "/task/" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("fields", "status");
        while (n > 0 && string2.equals("ACTIVE")) {
            JSONTransferAPIClient.Result result = this.client.getResult(string3, hashMap);
            string2 = result.document.getString("status");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            n -= 10;
        }
        return !string2.equals("ACTIVE");
    }

    public String copyEndpoint(String string, String string2) throws IOException, JSONException, GeneralSecurityException, APIError {
        String string3 = BaseTransferAPIClient.endpointPath(string);
        JSONTransferAPIClient.Result result = this.client.getResult(string3);
        JSONObject jSONObject = result.document;
        jSONObject.put("name", string2);
        jSONObject.remove("username");
        jSONObject.remove("canonical_name");
        result = this.client.postResult("/endpoint", jSONObject);
        return result.document.getString("code");
    }

    public String setEndpointDescription(String string, String string2) throws IOException, JSONException, GeneralSecurityException, APIError {
        String string3 = BaseTransferAPIClient.endpointPath(string);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("DATA_TYPE", "endpoint");
        jSONObject.put("description", string2);
        JSONTransferAPIClient.Result result = this.client.putResult(string3, jSONObject);
        return result.document.getString("code");
    }

    public String deleteEndpoint(String string) throws IOException, JSONException, GeneralSecurityException, APIError {
        String string2 = BaseTransferAPIClient.endpointPath(string);
        JSONTransferAPIClient.Result result = this.client.deleteResult(string2);
        return result.document.getString("code");
    }
}

