/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.ac.impl;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.VOMSGenericAttribute;
import org.italiangrid.voms.util.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VOMSAttributesImpl
implements VOMSAttribute {
    public static final int DEFAULT_CLOCK_SKEW_IN_MINUTES = 5;
    private String VO;
    private String host;
    private int port;
    private List<String> FQANs;
    private X500Principal issuer;
    private X500Principal holder;
    private BigInteger holderSerialNumber;
    private Date notAfter;
    private Date notBefore;
    private byte[] signature;
    private List<VOMSGenericAttribute> genericAttributes;
    private List<String> acTargets;
    private X509Certificate[] aaCerts;
    private X509AttributeCertificateHolder VOMSAC;

    @Override
    public X500Principal getIssuer() {
        return this.issuer;
    }

    @Override
    public String getPrimaryFQAN() {
        return this.FQANs.get(0);
    }

    @Override
    public String getVO() {
        return this.VO;
    }

    public void setIssuer(X500Principal issuer) {
        this.issuer = issuer;
    }

    public void setVO(String vO) {
        this.VO = vO;
    }

    @Override
    public List<String> getFQANs() {
        return this.FQANs;
    }

    public void setFQANs(List<String> fQANs) {
        this.FQANs = fQANs;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public X500Principal getHolder() {
        return this.holder;
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public Date getNotAfter() {
        return this.notAfter;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHolder(X500Principal holder) {
        this.holder = holder;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String toString() {
        return "VOMSAttributesImpl [VO=" + this.VO + ", host=" + this.host + ", port=" + this.port + ", FQANs=" + this.FQANs + ", gas=" + this.genericAttributes + ", issuer='" + X500NameUtils.getReadableForm(this.issuer) + "', holder='" + X500NameUtils.getReadableForm(this.holder) + "', notAfter=" + this.notAfter + ", notBefore=" + this.notBefore + ", targets=" + this.acTargets + " ]";
    }

    @Override
    public List<VOMSGenericAttribute> getGenericAttributes() {
        return this.genericAttributes;
    }

    public void setGenericAttributes(List<VOMSGenericAttribute> genericAttributes) {
        this.genericAttributes = genericAttributes;
    }

    @Override
    public List<String> getTargets() {
        return this.acTargets;
    }

    public void setTargets(List<String> targets) {
        this.acTargets = targets;
    }

    @Override
    public X509Certificate[] getAACertificates() {
        return this.aaCerts;
    }

    public void setAACertificates(X509Certificate[] aaCerts) {
        this.aaCerts = aaCerts;
    }

    @Override
    public boolean isValid() {
        return this.validAt(new Date());
    }

    @Override
    public boolean validAt(Date date) {
        return TimeUtils.checkTimeInRangeWithSkew(date, this.getNotBefore(), this.getNotAfter(), 5);
    }

    @Override
    public X509AttributeCertificateHolder getVOMSAC() {
        return this.VOMSAC;
    }

    public void setVOMSAC(X509AttributeCertificateHolder ac) {
        this.VOMSAC = ac;
    }

    @Override
    public BigInteger getHolderSerialNumber() {
        return this.holderSerialNumber;
    }

    public void setHolderSerialNumber(BigInteger holderSerialNumber) {
        this.holderSerialNumber = holderSerialNumber;
    }
}

