/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.util;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.CRLParameters;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.RevocationParametersExt;
import eu.emi.security.authn.x509.impl.ValidatorParamsExt;
import java.util.Arrays;

public class CertificateValidatorBuilder {
    public static final CrlCheckingMode DEFAULT_CRL_CHECKS = CrlCheckingMode.REQUIRE;
    public static final OCSPCheckingMode DEFAULT_OCSP_CHECKS = OCSPCheckingMode.IGNORE;
    public static final NamespaceCheckingMode DEFAULT_NS_CHECKS = NamespaceCheckingMode.GLOBUS_EUGRIDPMA;

    private CertificateValidatorBuilder() {
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, StoreUpdateListener storeUpdateListener, long updateInterval, NamespaceCheckingMode namespaceChecks, CrlCheckingMode crlChecks, OCSPCheckingMode ocspChecks) {
        RevocationParametersExt revocationParameters = new RevocationParametersExt(crlChecks, new CRLParameters(), new OCSPParametes(ocspChecks));
        ValidatorParamsExt validationParams = new ValidatorParamsExt(revocationParameters, ProxySupport.ALLOW);
        if (storeUpdateListener != null) {
            validationParams.setInitialListeners(Arrays.asList(storeUpdateListener));
        }
        OpensslCertChainValidator validator = new OpensslCertChainValidator(trustAnchorsDir, namespaceChecks, updateInterval, validationParams);
        if (validationErrorListener != null) {
            validator.addValidationListener(validationErrorListener);
        }
        return validator;
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, null, 0L, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, StoreUpdateListener storeListener) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, storeListener, 0L, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, StoreUpdateListener storeListener, long updateInterval) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, storeListener, updateInterval, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir, ValidationErrorListener validationErrorListener, long updateInterval) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, validationErrorListener, null, updateInterval, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator(String trustAnchorsDir) {
        return CertificateValidatorBuilder.buildCertificateValidator(trustAnchorsDir, null, null, 0L, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }

    public static X509CertChainValidatorExt buildCertificateValidator() {
        return CertificateValidatorBuilder.buildCertificateValidator("/etc/grid-security/certificates", null, null, 0L, DEFAULT_NS_CHECKS, DEFAULT_CRL_CHECKS, DEFAULT_OCSP_CHECKS);
    }
}

