/*
 * Decompiled with CFR 0.152.
 */
package org.lirc.socket;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.lirc.socket.UnixSocketInputStream;
import org.lirc.socket.UnixSocketOutputStream;

public class UnixSocketImpl {
    private int fd = -1;

    private UnixSocketImpl(int n) {
        this.fd = n;
    }

    protected UnixSocketImpl() throws IOException {
        this.fd = UnixSocketImpl.createSocket();
    }

    protected int getFd() {
        return this.fd;
    }

    protected static native int createSocket() throws IOException;

    protected native void bind(String var1) throws IOException;

    protected native void listen(int var1) throws IOException;

    protected UnixSocketImpl accept() throws IOException {
        return new UnixSocketImpl(this.nativeAccept());
    }

    private native int nativeAccept() throws IOException;

    protected native void connect(String var1) throws IOException;

    protected native void close() throws IOException;

    protected native void shutdownInput() throws IOException;

    protected native void shutdownOutput() throws IOException;

    protected UnixSocketInputStream getInputStream() throws IOException {
        return new UnixSocketInputStream(this);
    }

    protected UnixSocketOutputStream getOutputStream() throws IOException {
        return new UnixSocketOutputStream(this);
    }

    static {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        String string3 = System.mapLibraryName("junixsocket");
        if (string.equals("Linux") && string2.equals("amd64")) {
            string3 = System.mapLibraryName("junixsocket64");
        }
        try {
            int n;
            File file = new File("/tmp/" + string3);
            InputStream inputStream = UnixSocketImpl.class.getResourceAsStream(string3);
            FileOutputStream fileOutputStream = new FileOutputStream(file.getPath());
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)fileOutputStream).close();
            inputStream.close();
            file.deleteOnExit();
            System.load(file.getPath());
        }
        catch (Exception exception) {
            System.err.println("Failed to extract native socket library to /tmp");
        }
    }
}

