/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rl.esc.browser;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.X509ExtensionSet;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.proxy.ext.GlobusProxyCertInfoExtension;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyCertInfoExtension;
import org.globus.gsi.proxy.ext.ProxyPolicy;

class BouncyCastleCertProcessingFactoryProvider {
    private static BouncyCastleCertProcessingFactoryProvider factory;

    protected BouncyCastleCertProcessingFactoryProvider() {
    }

    public static synchronized BouncyCastleCertProcessingFactoryProvider getDefault() {
        if (factory == null) {
            factory = new BouncyCastleCertProcessingFactoryProvider();
        }
        return factory;
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, Provider p) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, delegationMode, (X509ExtensionSet)null, (String)null, p);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, X509ExtensionSet extSet, Provider p) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, delegationMode, extSet, null, p);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, X509ExtensionSet extSet, String cnValue, Provider p) throws IOException, GeneralSecurityException {
        ASN1InputStream derin = new ASN1InputStream(certRequestInputStream);
        DERObject reqInfo = derin.readObject();
        PKCS10CertificationRequest certReq = new PKCS10CertificationRequest((ASN1Sequence)((Object)reqInfo));
        boolean rs = certReq.verify();
        if (!rs) {
            throw new GeneralSecurityException("Certificate request verification failed!");
        }
        return this.createProxyCertificate(cert, privateKey, certReq.getPublicKey(), lifetime, delegationMode, extSet, cnValue, p);
    }

    public X509Certificate loadCertificate(InputStream in) throws IOException, GeneralSecurityException {
        ASN1InputStream derin = new ASN1InputStream(in);
        DERObject certInfo = derin.readObject();
        ASN1Sequence seq = ASN1Sequence.getInstance(certInfo);
        return new X509CertificateObject(new X509CertificateStructure(seq));
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, Provider p) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegationMode, (X509ExtensionSet)null, (String)null, p);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, X509ExtensionSet extSet, Provider p) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegationMode, extSet, null, p);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, X509ExtensionSet extSet, String cnValue, Provider p) throws GeneralSecurityException {
        KeyPairGenerator keyGen = null;
        keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyGen.initialize(bits);
        KeyPair keyPair = keyGen.genKeyPair();
        X509Certificate newCert = this.createProxyCertificate(certs[0], privateKey, keyPair.getPublic(), lifetime, delegationMode, extSet, cnValue, p);
        X509Certificate[] newCerts = new X509Certificate[certs.length + 1];
        newCerts[0] = newCert;
        System.arraycopy(certs, 0, newCerts, 1, certs.length);
        return new X509Credential(keyPair.getPrivate(), newCerts);
    }

    public byte[] createCertificateRequest(String subject, KeyPair keyPair) throws GeneralSecurityException {
        X509Name name = new X509Name(subject);
        return this.createCertificateRequest(name, "MD5WithRSAEncryption", keyPair);
    }

    public byte[] createCertificateRequest(X509Certificate cert, KeyPair keyPair) throws GeneralSecurityException {
        String issuer = cert.getSubjectDN().getName();
        X509Name subjectDN = new X509Name(String.valueOf(issuer) + ",CN=proxy");
        String sigAlgName = cert.getSigAlgName();
        return this.createCertificateRequest(subjectDN, sigAlgName, keyPair);
    }

    public byte[] createCertificateRequest(X509Name subjectDN, String sigAlgName, KeyPair keyPair) throws GeneralSecurityException {
        ASN1Set attrs = null;
        PKCS10CertificationRequest certReq = null;
        certReq = new PKCS10CertificationRequest(sigAlgName, subjectDN, keyPair.getPublic(), attrs, keyPair.getPrivate());
        return certReq.getEncoded();
    }

    /*
     * Unable to fully structure code
     */
    protected X509Certificate createProxyCertificate(X509Certificate issuerCert, PrivateKey issuerKey, PublicKey publicKey, int lifetime, int proxyType, X509ExtensionSet extSet, String cnValue, Provider p) throws GeneralSecurityException {
        proxyType = BouncyCastleUtil.getCertificateType(issuerCert).getCode();
        certGen = new X509V3CertificateGenerator();
        x509Ext = null;
        serialNum = null;
        delegDN = null;
        if (proxyType == GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_3_LIMITED_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_LIMITED_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY.getCode()) {
            rand = new Random();
            delegDN = String.valueOf(Math.abs(rand.nextInt()));
            serialNum = new BigInteger(20, rand);
            if (extSet != null) {
                x509Ext = extSet.get(ProxyCertInfo.OID.getId());
            }
            if (x509Ext == null) {
                policy = null;
                if (proxyType == GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode()) {
                    policy = new ProxyPolicy((DERObjectIdentifier)ProxyPolicy.IMPERSONATION);
                } else if (proxyType == GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY.getCode()) {
                    policy = new ProxyPolicy((DERObjectIdentifier)ProxyPolicy.INDEPENDENT);
                } else if (proxyType == GSIConstants.CertificateType.GSI_3_LIMITED_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_LIMITED_PROXY.getCode()) {
                    policy = new ProxyPolicy((DERObjectIdentifier)ProxyPolicy.LIMITED);
                } else {
                    if (proxyType == GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY.getCode()) {
                        throw new IllegalArgumentException("Restricted proxy requires ProxyCertInfo extension");
                    }
                    throw new IllegalArgumentException("Invalid proxyType");
                }
                proxyCertInfo = new ProxyCertInfo(policy);
                x509Ext = proxyType == GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_LIMITED_PROXY.getCode() || proxyType == GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY.getCode() ? new ProxyCertInfoExtension(proxyCertInfo) : new GlobusProxyCertInfoExtension(proxyCertInfo);
            }
            try {
                certGen.addExtension(x509Ext.getOid(), x509Ext.isCritical(), x509Ext.getValue());
                crt = BouncyCastleUtil.getTBSCertificateStructure(issuerCert);
                extensions = crt.getExtensions();
                if (extensions == null || (ext = extensions.getExtension(X509Extensions.KeyUsage)) == null) ** GOTO lbl55
                if (extSet != null && extSet.get(X509Extensions.KeyUsage.getId()) != null) {
                    throw new GeneralSecurityException("KeyUsage extension present in X509ExtensionSet and in issuer certificate.");
                }
                bits = (DERBitString)BouncyCastleUtil.getExtensionObject((X509Extension)ext);
                bytes = bits.getBytes();
                if ((bytes[0] & 64) != 0) {
                    bytes[0] = (byte)(bytes[0] ^ 64);
                }
                if ((bytes[0] & 4) != 0) {
                    bytes[0] = (byte)(bytes[0] ^ 4);
                }
                bits = new DERBitString(bytes, bits.getPadBits());
                certGen.addExtension(X509Extensions.KeyUsage, ext.isCritical(), (DEREncodable)bits);
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
        } else if (proxyType == 11) {
            delegDN = "limited proxy";
            serialNum = issuerCert.getSerialNumber();
        } else if (proxyType == 10) {
            delegDN = "proxy";
            serialNum = issuerCert.getSerialNumber();
        } else {
            throw new IllegalArgumentException("Unsupported proxyType : " + proxyType);
        }
lbl55:
        // 4 sources

        if (extSet != null) {
            for (String oid : extSet.oidSet()) {
                if (oid.equals(ProxyCertInfo.OID.getId()) || oid.equals(ProxyCertInfo.OLD_OID.getId())) continue;
                x509Ext = extSet.get(oid);
                certGen.addExtension(x509Ext.getOid(), x509Ext.isCritical(), x509Ext.getValue());
            }
        }
        issuerDN = (X509Name)issuerCert.getSubjectDN();
        issuer = new X509NameHelper(issuerDN);
        subject = new X509NameHelper(issuerDN);
        subject.add(X509Name.CN, cnValue == null ? delegDN : cnValue);
        certGen.setSubjectDN(subject.getAsName());
        certGen.setIssuerDN(issuer.getAsName());
        certGen.setSerialNumber(serialNum);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm("MD5withRSA");
        date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -5);
        certGen.setNotBefore(date.getTime());
        if (lifetime <= 0) {
            certGen.setNotAfter(issuerCert.getNotAfter());
        } else {
            date.add(12, 5);
            date.add(13, lifetime);
            certGen.setNotAfter(date.getTime());
        }
        return certGen.generateX509Certificate(issuerKey, p.getName());
    }

    private X509ExtensionSet createExtensionSet(ProxyCertInfo proxyCertInfo) {
        X509ExtensionSet set = null;
        if (proxyCertInfo != null) {
            set = new X509ExtensionSet();
            set.add(new ProxyCertInfoExtension(proxyCertInfo));
        }
        return set;
    }

    protected X509Certificate createProxyCertificate(X509Certificate issuerCert, PrivateKey issuerKey, PublicKey publicKey, int lifetime, int proxyType, ProxyCertInfo proxyCertInfo, String cnValue, Provider p) throws GeneralSecurityException {
        return this.createProxyCertificate(issuerCert, issuerKey, publicKey, lifetime, proxyType, this.createExtensionSet(proxyCertInfo), cnValue, p);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, ProxyCertInfo proxyCertInfoExt, String cnValue, Provider p) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegationMode, this.createExtensionSet(proxyCertInfoExt), cnValue, p);
    }

    public X509Credential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, ProxyCertInfo proxyCertInfoExt, Provider p) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegationMode, proxyCertInfoExt, null, p);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, ProxyCertInfo proxyCertInfoExt, String cnValue, Provider p) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, delegationMode, this.createExtensionSet(proxyCertInfoExt), cnValue, p);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, ProxyCertInfo proxyCertInfoExt, Provider p) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, delegationMode, proxyCertInfoExt, null, p);
    }
}

