/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.UnsupportedRuleException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class RemoteIdentificationRule {
    private static HashSet allowedOperations = new HashSet();
    private HashMap expressions = new HashMap();
    private int priority = 10;
    private String name;

    public boolean testRule(String identification) {
        String svc = identification.substring(identification.lastIndexOf("-") + 1);
        Iterator it = this.expressions.entrySet().iterator();
        boolean pass = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String operation = (String)entry.getKey();
            if (operation.equals("startsWith")) {
                pass = svc.startsWith((String)entry.getValue());
            }
            if (!operation.equals("contains")) continue;
            pass = svc.indexOf((String)entry.getValue()) >= 0;
        }
        return pass;
    }

    protected void setPriority(int priority) {
        this.priority = priority;
    }

    protected void addExpression(String operation, String value) throws UnsupportedRuleException {
        if (!allowedOperations.contains(operation)) {
            throw new UnsupportedRuleException("The rule '" + operation + "' is not supported");
        }
        this.expressions.put(operation, value);
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    static {
        allowedOperations.add("startsWith");
        allowedOperations.add("contains");
    }
}

