/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.myproxytool;

import com.sshtools.common.myproxytool.CredentialHelper;
import com.sshtools.common.myproxytool.MyProxyToolPanel;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.authentication.UserGridCredential;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.globus.common.CoGProperties;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.myproxy.CredentialInfo;
import org.globus.myproxy.DestroyParams;
import org.globus.myproxy.GetParams;
import org.globus.myproxy.InfoParams;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.globus.util.Util;
import org.ietf.jgss.GSSCredential;

public class Main
extends JFrame
implements ActionListener {
    static final String ICON = "/com/sshtools/common/myproxytool/largemyproxy.png";
    static final int CREATE_STORE_PROXY = 0;
    static final int REMOVE_DESTROY_PROXY = 1;
    static final int PROXY_INFORMATION = 2;
    String userName = "";
    String hostName = "";
    int port = 0;
    int lifetime = 0;
    String certType = null;
    String dn = null;
    boolean voms = false;
    JButton close;
    JButton generate;
    MyProxyToolPanel myproxypanel;
    JComboBox action;
    private String passphrase = null;
    private String confirmPassphrase = null;

    public Main() {
        super("MyProxy Tool");
        try {
            ConfigurationLoader.initialize(false);
        }
        catch (ConfigurationException ex) {
            // empty catch block
        }
        this.setIconImage(new ResourceIcon(this.getClass(), ICON).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Main.this.myproxypanel.getPKCS12Cert() != null && !Main.this.myproxypanel.getPKCS12Cert().trim().equals("")) {
                    PreferencesStore.put("sshterm.pkcs12.defaults.file", Main.this.myproxypanel.getPKCS12Cert().trim());
                }
                if (Main.this.myproxypanel.getMyProxyServer() != null && !Main.this.myproxypanel.getMyProxyServer().trim().equals("")) {
                    PreferencesStore.put("sshterm.myproxy.defaults.hostname", Main.this.myproxypanel.getMyProxyServer().trim());
                }
                if (Main.this.myproxypanel.getPort() != 0) {
                    PreferencesStore.put("sshterm.myproxy.defaults.port", Main.this.myproxypanel.getPort() + "");
                }
                if (Main.this.myproxypanel.getUsername() != null && !Main.this.myproxypanel.getUsername().trim().equals("")) {
                    PreferencesStore.put("sshterm.myproxy.defaults.username", Main.this.myproxypanel.getUsername().trim());
                }
                Main.this.dispose();
            }
        });
        try {
            String globusCertDir = System.getProperty("user.home") + File.separator + ".globus" + File.separator + "certificates";
            if (!new File(globusCertDir).exists()) {
                UserGridCredential.checkCACertificates(CoGProperties.getDefault());
            }
        }
        catch (IOException e1) {
            System.out.println("Failed to update CA certificates");
        }
        JPanel selectActionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 2, 4, 2);
        gbc.weightx = 0.0;
        this.action = new JComboBox<String>(new String[]{"Create and upload proxy", "Remove or destroy proxy", "Retrieve proxy information"});
        this.action.addActionListener(this);
        UIUtil.jGridBagAdd(selectActionPanel, this.action, gbc, -1);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(selectActionPanel, new JLabel(), gbc, 0);
        IconWrapperPanel northPanel = new IconWrapperPanel(new ResourceIcon(this.getClass(), ICON), selectActionPanel);
        northPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.myproxypanel = new MyProxyToolPanel();
        JPanel centerPanel = new JPanel(new FlowLayout(0, 0, 0));
        centerPanel.add(this.myproxypanel);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(6, 6, 0, 0);
        gbc.weighty = 1.0;
        this.generate = new JButton("Create and Store");
        this.generate.addActionListener(this);
        this.generate.setMnemonic('u');
        this.getRootPane().setDefaultButton(this.generate);
        UIUtil.jGridBagAdd(buttonPanel, this.generate, gbc, -1);
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        this.close.setMnemonic('c');
        UIUtil.jGridBagAdd(buttonPanel, this.close, gbc, 0);
        JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
        southPanel.add(buttonPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JScrollPane mainScroller = new JScrollPane(mainPanel);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)northPanel, "North");
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)southPanel, "South");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(mainScroller);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        block29: {
            if (evt.getSource() == this.close) {
                if (this.myproxypanel.getPKCS12Cert() != null && !this.myproxypanel.getPKCS12Cert().trim().equals("")) {
                    PreferencesStore.put("sshterm.pkcs12.defaults.file", this.myproxypanel.getPKCS12Cert().trim());
                }
                if (this.myproxypanel.getMyProxyServer() != null && !this.myproxypanel.getMyProxyServer().trim().equals("")) {
                    PreferencesStore.put("sshterm.myproxy.defaults.hostname", this.myproxypanel.getMyProxyServer().trim());
                }
                if (this.myproxypanel.getPort() != 0) {
                    PreferencesStore.put("sshterm.myproxy.defaults.port", this.myproxypanel.getPort() + "");
                }
                if (this.myproxypanel.getUsername() != null && !this.myproxypanel.getUsername().trim().equals("")) {
                    PreferencesStore.put("sshterm.myproxy.defaults.username", this.myproxypanel.getUsername().trim());
                }
                this.dispose();
                return;
            }
            String localPassphrase = new String(this.myproxypanel.getLocalPassphrase()).trim();
            this.userName = new String(this.myproxypanel.getUsername());
            this.hostName = new String(this.myproxypanel.getMyProxyServer());
            this.port = this.myproxypanel.getPort();
            this.lifetime = this.myproxypanel.getLifetime();
            this.certType = this.myproxypanel.getCertType();
            this.voms = this.myproxypanel.getVOMSSupport();
            String pkcs12cert = this.myproxypanel.getPKCS12Cert();
            String existingProxyCert = this.myproxypanel.getExistingProxyCert();
            try {
                GSSCredential gsscredential = null;
                GSIConstants.CertificateType proxyType = GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY;
                if (this.getAction() == 0) {
                    String voName;
                    this.myproxypanel.triggerLocalCertificatePanel(true);
                    if (!this.certType.equals("Existing proxy")) {
                        this.myproxypanel.triggerLifetime(true);
                    }
                    this.generate.setText("Create and Store");
                    if (evt.getSource() != this.generate || (gsscredential = this.createCredential(localPassphrase, proxyType, this.lifetime, pkcs12cert, existingProxyCert)) == null) break block29;
                    boolean ok = this.createConfirmPassphraseDialog();
                    MyProxy myProxy = this.getMyProxy();
                    if (!ok) break block29;
                    myProxy.put(gsscredential, this.userName, this.passphrase, this.lifetime * 3600);
                    if (this.myproxypanel.getVOMSRemoteSupport() && (voName = this.createSimpleVOMSDialog()) != null) {
                        try {
                            GetParams getRequest = new GetParams();
                            getRequest.setUserName(this.userName);
                            getRequest.setLifetime(this.lifetime * 3600);
                            getRequest.setPassphrase(this.passphrase);
                            ArrayList<String> vonameList = new ArrayList<String>();
                            vonameList.add(voName);
                            getRequest.setVoname(vonameList);
                            GSSCredential vomGsscredential = myProxy.get(null, getRequest);
                            myProxy.put(vomGsscredential, this.userName, this.passphrase, this.lifetime * 3600);
                        }
                        catch (MyProxyException e) {
                            e.printStackTrace();
                        }
                    }
                    JOptionPane.showMessageDialog(this, "Proxy is successfully created and stored.", "MyProxy status", 1, new ResourceIcon(this.getClass(), ICON));
                    break block29;
                }
                if (this.getAction() == 1) {
                    this.generate.setText("Destroy");
                    this.myproxypanel.triggerLifetime(false);
                    gsscredential = CredentialHelper.loadExistingProxy();
                    if (gsscredential != null) {
                        this.myproxypanel.triggerLocalCertificatePanel(false);
                    } else {
                        this.myproxypanel.triggerLocalCertificatePanel(true);
                    }
                    if (evt.getSource() != this.generate) break block29;
                    if (gsscredential == null) {
                        gsscredential = this.createCredential(localPassphrase, proxyType, this.lifetime, pkcs12cert, existingProxyCert);
                    }
                    DestroyParams destroyRequest = new DestroyParams();
                    destroyRequest.setUserName(this.userName);
                    destroyRequest.setCredentialName(null);
                    destroyRequest.setPassphrase("DUMMY-PASSPHRASE");
                    try {
                        MyProxy myProxy = this.getMyProxy();
                        myProxy.destroy(gsscredential, destroyRequest);
                        JOptionPane.showMessageDialog(this, "Proxy is successfully removed/destroyed.", "MyProxy status", 1, new ResourceIcon(this.getClass(), ICON));
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("Credentials do not exist")) {
                            JOptionPane.showMessageDialog(this, "No credential found for user '" + this.userName + "'", "MyProxy Error", 0);
                            break block29;
                        }
                        JOptionPane.showMessageDialog(this, e.getMessage(), "MyProxy Error", 0);
                    }
                    break block29;
                }
                if (this.getAction() == 2) {
                    this.generate.setText("Retrieve");
                    this.myproxypanel.triggerLifetime(false);
                    gsscredential = CredentialHelper.loadExistingProxy();
                    if (gsscredential != null) {
                        this.myproxypanel.triggerLocalCertificatePanel(false);
                    } else {
                        this.myproxypanel.triggerLocalCertificatePanel(true);
                    }
                    if (evt.getSource() == this.generate) {
                        if (gsscredential == null) {
                            gsscredential = this.createCredential(localPassphrase, proxyType, this.lifetime, pkcs12cert, existingProxyCert);
                        }
                        InfoParams infoRequest = new InfoParams();
                        infoRequest.setUserName(this.userName);
                        infoRequest.setPassphrase("DUMMY-PASSPHRASE");
                        String proxyInfo = "";
                        try {
                            MyProxy myProxy = this.getMyProxy();
                            CredentialInfo[] info = myProxy.info(gsscredential, infoRequest);
                            proxyInfo = proxyInfo + "From MyProxy server: " + myProxy.getHost() + "\n";
                            proxyInfo = proxyInfo + "Owner: " + info[0].getOwner() + "\n";
                            proxyInfo = proxyInfo + "Username: " + this.userName + "\n";
                            for (int i = 0; i < info.length; ++i) {
                                String tmp = info[i].getName();
                                proxyInfo = proxyInfo + (tmp == null ? "default:" : tmp + ":\n");
                                proxyInfo = proxyInfo + "\tStart Time  : " + new Date(info[i].getStartTime()) + "\n";
                                proxyInfo = proxyInfo + "\tEnd Time    : " + new Date(info[i].getEndTime()) + "\n";
                                long now = System.currentTimeMillis();
                                proxyInfo = info[i].getEndTime() > now ? proxyInfo + "\tTime left   : " + Util.formatTimeSec((info[i].getEndTime() - now) / 1000L) + "\n" : proxyInfo + "\tTime left   : expired\n";
                                tmp = info[i].getRetrievers();
                                if (tmp != null) {
                                    proxyInfo = proxyInfo + "\tRetrievers  : " + tmp + "\n";
                                }
                                if ((tmp = info[i].getRenewers()) != null) {
                                    proxyInfo = proxyInfo + "\tRenewers    : " + tmp + "\n";
                                }
                                if ((tmp = info[i].getDescription()) == null) continue;
                                proxyInfo = proxyInfo + "\tDescription : " + tmp + "\n";
                            }
                            JLabel lproxyInfo = new JLabel("Credential Information:");
                            JTextArea existingproxyInfo = new JTextArea(5, 20);
                            existingproxyInfo.append(proxyInfo);
                            JScrollPane scrollPane = new JScrollPane(existingproxyInfo);
                            existingproxyInfo.setEditable(false);
                            Object[] obj = new Object[]{lproxyInfo, existingproxyInfo};
                            JOptionPane.showMessageDialog(this, obj, "MyProxy credential information", 1);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(this, e.getMessage(), "MyProxy Error", 0);
                        }
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "MyProxy Error", 0);
            }
        }
    }

    public int getAction() {
        return this.action.getSelectedIndex();
    }

    private GSSCredential createCredential(String localPassphrase, GSIConstants.CertificateType proxyType, int lifetime, String pkcs12cert, String existingProxyCert) throws Exception {
        GSSCredential defensivecopy;
        GSSCredential gsscredential = null;
        X509Credential proxy = null;
        boolean error = false;
        if (this.voms) {
            JLabel question = new JLabel("Authentication with VOs before logging in?");
            JLabel proxyTypeLB = new JLabel("Proxy Type: ");
            JComboBox<String> proxyTypeCB = new JComboBox<String>(new String[]{"Legacy", "RFC Impersonation"});
            String cur = PreferencesStore.get("sshterm.voms.proxyType", Integer.toString(GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode()));
            if (cur.equals(Integer.toString(GSIConstants.CertificateType.GSI_2_PROXY.getCode()))) {
                proxyTypeCB.setSelectedIndex(0);
            } else {
                proxyTypeCB.setSelectedIndex(1);
            }
            Object[] obj = new Object[]{question, proxyTypeLB, proxyTypeCB};
            int result = JOptionPane.showConfirmDialog(null, obj, "Enable VOMS ?", 0);
            if (result == 0) {
                int index = proxyTypeCB.getSelectedIndex();
                if (index == 0) {
                    proxyType = GSIConstants.CertificateType.GSI_2_PROXY;
                } else if (index == 1) {
                    proxyType = GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY;
                }
            }
        }
        if (this.certType.equals("PEM")) {
            try {
                proxy = UserGridCredential.createProxy(localPassphrase, proxyType, lifetime);
            }
            catch (Exception ex) {
                error = true;
                JOptionPane.showMessageDialog(this, "Cannot find your PEM certificates in {home directory}/.globus/ or incorrect passphrase.", "MyProxy Error", 0);
            }
        } else if (this.certType.equals("PKCS12")) {
            try {
                proxy = CredentialHelper.createProxyFromPKCS12(localPassphrase, proxyType, lifetime, pkcs12cert);
            }
            catch (Exception ex) {
                error = true;
                JOptionPane.showMessageDialog(null, ex.getMessage(), "MyProxy Error", 0);
            }
        } else if (this.certType.equals("Existing proxy")) {
            try {
                proxy = CredentialHelper.retrieveExistingProxy(existingProxyCert);
            }
            catch (Exception ex) {
                error = true;
                JOptionPane.showMessageDialog(null, ex.getMessage(), "MyProxy Error", 0);
            }
        }
        if (proxy != null) {
            try {
                proxy.verify();
                gsscredential = new GlobusGSSCredentialImpl(proxy, 1);
            }
            catch (Exception exception1) {
                error = true;
                if (exception1.getMessage().indexOf("Expired credentials") >= 0) {
                    JOptionPane.showMessageDialog(this, "Credentials have expired.", "MyProxy Error", 0);
                }
                JOptionPane.showMessageDialog(this, "Could not load your certificate.", "MyProxy Error", 0);
            }
        }
        if (!error && this.voms && (defensivecopy = UserGridCredential.vomsEnable(gsscredential)) != null) {
            gsscredential = defensivecopy;
        }
        return gsscredential;
    }

    private boolean createConfirmPassphraseDialog() {
        for (int counter = 0; counter < 3; ++counter) {
            try {
                JLabel lmyProxyPassphrase = new JLabel("Upload Passphrase:");
                JPasswordField myProxyPassphrase = new JPasswordField(20);
                JLabel lmyProxyPassphraseConfirm = new JLabel("Comfirm Upload Passphrase:");
                JPasswordField myProxyPassphraseConfirm = new JPasswordField(20);
                Object[] obj = new Object[]{lmyProxyPassphrase, myProxyPassphrase, lmyProxyPassphraseConfirm, myProxyPassphraseConfirm};
                int result = JOptionPane.showConfirmDialog(this, obj, "Please input passphrase for storing your proxy", 2);
                if (result == 0) {
                    this.passphrase = new String(myProxyPassphrase.getPassword()).trim();
                    this.confirmPassphrase = new String(myProxyPassphraseConfirm.getPassword()).trim();
                    if (!this.passphrase.equals(this.confirmPassphrase)) {
                        throw new Exception("Passphrase and Confirm Passphrase do not match. Please try again.");
                    }
                    return true;
                }
                break;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "MyProxy Error", 0);
                continue;
            }
        }
        return false;
    }

    private String createSimpleVOMSDialog() {
        for (int counter = 0; counter < 3; ++counter) {
            String voName;
            JLabel lvoms = new JLabel("VO:");
            JTextField tbVOName = new JTextField();
            Object[] obj = new Object[]{lvoms, tbVOName};
            int result = JOptionPane.showConfirmDialog(this, obj, "Please enter VO name", 2);
            if (result != 0 || (voName = tbVOName.getText().trim()) == null || voName.equals("")) continue;
            return voName;
        }
        return null;
    }

    private MyProxy getMyProxy() {
        MyProxy myProxy = new MyProxy(this.hostName, this.port);
        if (this.dn != null) {
            myProxy.setAuthorization(new IdentityAuthorization(this.dn));
        }
        return myProxy;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        Main main = new Main();
        main.pack();
        UIUtil.positionComponent(0, main);
        main.setVisible(true);
    }
}

