/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionCallback;
import com.sshtools.common.ui.OptionsDialog;
import com.sshtools.common.ui.SessionManager;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationSessionPanel
extends SshToolsApplicationPanel {
    public static final String PREF_CONNECTION_FILE_DIRECTORY = "sshapps.connectionFile.directory";
    protected Log log = LogFactory.getLog(SshToolsApplicationSessionPanel.class);
    protected SshToolsConnectionProfile currentConnectionProfile;
    protected SessionManager manager;

    public SshToolsApplicationSessionPanel() {
    }

    public SshToolsApplicationSessionPanel(LayoutManager mgr) {
        super(mgr);
    }

    public abstract SshToolsConnectionTab[] getAdditionalConnectionTabs();

    public abstract void addEventListener(ChannelEventListener var1);

    public abstract boolean requiresConfiguration();

    public abstract String getId();

    public boolean singleFrame() {
        return false;
    }

    public final boolean openSession(SessionManager manager, SshToolsConnectionProfile profile) throws IOException {
        this.manager = manager;
        this.setCurrentConnectionProfile(profile);
        if (this.requiresConfiguration() && !profile.getApplicationPropertyBoolean(this.getId() + ".configured", false) && !this.editSettings(profile)) {
            return false;
        }
        return this.onOpenSession();
    }

    public abstract boolean onOpenSession() throws IOException;

    @Override
    public boolean isConnected() {
        return this.manager != null && this.manager.isConnected();
    }

    @Override
    public void setContainerTitle(String host) {
        String verString = "";
        if (this.application != null) {
            verString = ConfigurationLoader.getVersionString(this.application.getApplicationName(), this.application.getApplicationVersion());
        }
        if (this.container != null) {
            this.container.setContainerTitle(host == null ? verString : verString + " [" + host + "]");
        }
    }

    public void setCurrentConnectionProfile(SshToolsConnectionProfile profile) {
        this.currentConnectionProfile = profile;
    }

    public SshToolsConnectionProfile getCurrentConnectionProfile() {
        return this.currentConnectionProfile;
    }

    public boolean editSettings(SshToolsConnectionProfile profile) {
        final SshToolsConnectionPanel panel = new SshToolsConnectionPanel(false);
        SshToolsConnectionTab[] tabs = this.getAdditionalConnectionTabs();
        for (int i = 0; tabs != null && i < tabs.length; ++i) {
            tabs[i].setConnectionProfile(profile);
            panel.addTab(tabs[i]);
        }
        panel.setConnectionProfile(profile);
        final Option ok = new Option("Ok", "Apply the settings and close this dialog", 111);
        Option cancel = new Option("Cancel", "Close this dialog without applying the settings", 99);
        OptionCallback callback = new OptionCallback(){

            @Override
            public boolean canClose(OptionsDialog dialog, Option option) {
                if (option == ok) {
                    return panel.validateTabs();
                }
                return true;
            }
        };
        OptionsDialog od = OptionsDialog.createOptionDialog(this, new Option[]{ok, cancel}, panel, "Connection Settings", ok, callback, null);
        od.pack();
        UIUtil.positionComponent(0, od);
        od.setVisible(true);
        if (od.getSelectedOption() == ok) {
            panel.applyTabs();
            this.manager.applyProfileChanges(profile);
            return true;
        }
        return false;
    }

    class MenuItemActionComparator
    implements Comparator {
        MenuItemActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("menuItemGroup")).compareTo((Integer)((StandardAction)o2).getValue("menuItemGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("menuItemWeight")).compareTo((Integer)((StandardAction)o2).getValue("menuItemWeight")) : i;
        }
    }

    class ToolBarActionComparator
    implements Comparator {
        ToolBarActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("toolBarGroup")).compareTo((Integer)((StandardAction)o2).getValue("toolBarGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("toolBarWeight")).compareTo((Integer)((StandardAction)o2).getValue("toolBarWeight")) : i;
        }
    }
}

