/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionHostTab;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsConnectionKerberosTab
extends JPanel
implements SshToolsConnectionTab {
    public static final String CONNECT_ICON = "largeserveridentity.png";
    public static final String AUTH_ICON = "largelock.png";
    public static final String SHOW_AVAILABLE = "<Show available methods>";
    protected XTextField jTextHostname = new XTextField();
    protected XTextField jTextUsername = new XTextField();
    protected XTextField jTextRealm = new XTextField();
    protected XTextField jTextKDC = new XTextField();
    protected SshToolsConnectionProfile profile;
    protected JCheckBox useKerberos;
    protected Log log = LogFactory.getLog(SshToolsConnectionHostTab.class);

    public SshToolsConnectionKerberosTab() {
        JPanel mainConnectionDetailsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 2, 2, 2);
        this.useKerberos = new JCheckBox("Use MyProxy Kerberos support");
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.useKerberos, gbc, 0);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, new JLabel("Hostname"), gbc, 0);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.jTextHostname, gbc, 0);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, new JLabel("Username"), gbc, 0);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.jTextUsername, gbc, 0);
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        settingsPanel.setBorder(BorderFactory.createTitledBorder("Settings if krb5.conf or krb5.ini file not found: "));
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = 2;
        gbc2.anchor = 18;
        gbc2.insets = new Insets(0, 2, 2, 2);
        gbc2.weightx = 1.0;
        UIUtil.jGridBagAdd(settingsPanel, new JLabel("Realm"), gbc2, 0);
        gbc2.fill = 2;
        UIUtil.jGridBagAdd(settingsPanel, this.jTextRealm, gbc2, 0);
        gbc2.fill = 0;
        UIUtil.jGridBagAdd(settingsPanel, new JLabel("KDC"), gbc2, 0);
        gbc2.fill = 2;
        gbc2.weighty = 1.0;
        UIUtil.jGridBagAdd(settingsPanel, this.jTextKDC, gbc2, 0);
        gbc2.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 2, 2, 2);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, settingsPanel, gbc, 0);
        IconWrapperPanel iconMainConnectionDetailsPanel = new IconWrapperPanel(new ResourceIcon(SshToolsConnectionHostTab.class, AUTH_ICON), mainConnectionDetailsPanel);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(this, iconMainConnectionDetailsPanel, gbc, 0);
    }

    @Override
    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        String hostname = "myproxy-sso.grid-support.ac.uk";
        String username = System.getProperty("user.name");
        String realm = System.getenv("USERDNSDOMAIN");
        String kdc = System.getenv("USERDNSDOMAIN");
        boolean use = true;
        hostname = PreferencesStore.get("sshterm.krb5myproxy.hostname", hostname);
        username = PreferencesStore.get("sshterm.krb5myproxy.username", username);
        realm = PreferencesStore.get("sshterm.krb5myproxy.relam", realm);
        kdc = PreferencesStore.get("sshterm.krb5myproxy.kdc", kdc);
        if (profile != null) {
            hostname = profile.getApplicationProperty("sshterm.krb5myproxy.hostname", hostname);
            username = profile.getApplicationProperty("sshterm.krb5myproxy.username", username);
            realm = profile.getApplicationProperty("sshterm.krb5myproxy.relam", realm);
            kdc = profile.getApplicationProperty("sshterm.krb5myproxy.kdc", kdc);
            use = profile.getApplicationPropertyBoolean("sshterm.krb5myproxy.enabled", use);
        }
        this.jTextHostname.setText(hostname);
        this.jTextUsername.setText(username);
        this.jTextRealm.setText(realm);
        this.jTextKDC.setText(kdc);
        this.useKerberos.setSelected(use);
    }

    @Override
    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    @Override
    public String getTabContext() {
        return "Connection";
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "Kerberos";
    }

    @Override
    public String getTabToolTipText() {
        return "Settings for using Kerberos enabled MyProxy servers.";
    }

    @Override
    public int getTabMnemonic() {
        return 107;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        return true;
    }

    @Override
    public void applyTab() {
        if (this.profile != null) {
            this.profile.setApplicationProperty("sshterm.krb5myproxy.hostname", this.jTextHostname.getText());
            this.profile.setApplicationProperty("sshterm.krb5myproxy.username", this.jTextUsername.getText());
            this.profile.setApplicationProperty("sshterm.krb5myproxy.relam", this.jTextRealm.getText());
            this.profile.setApplicationProperty("sshterm.krb5myproxy.kdc", this.jTextKDC.getText());
            this.profile.setApplicationProperty("sshterm.krb5myproxy.enabled", this.useKerberos.isSelected());
        }
    }

    @Override
    public void tabSelected() {
    }
}

