/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsConnectionHostTab;
import com.sshtools.common.ui.SshToolsConnectionProxyTab;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.SshToolsSimpleConnectionPrompt;
import com.sshtools.common.ui.Tabber;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsConnectionPanel
extends JPanel {
    static final String DEFAULT = "<Default>";
    static final int DEFAULT_PORT = 2222;
    protected static Log log = LogFactory.getLog(SshToolsConnectionPanel.class);
    private Tabber tabber = new Tabber();
    private SshToolsConnectionProfile profile;
    private SshToolsConnectionHostTab hosttab = null;

    public SshToolsConnectionPanel(boolean showConnectionTabs) {
        if (showConnectionTabs) {
            this.hosttab = new SshToolsConnectionHostTab();
            this.addTab(this.hosttab);
            this.addTab(new SshToolsConnectionProxyTab());
        }
        this.setLayout(new GridLayout(1, 1));
        this.add(this.tabber);
    }

    public boolean validateTabs() {
        return this.tabber.validateTabs();
    }

    public void applyTabs() {
        this.tabber.applyTabs();
    }

    public void addTab(SshToolsConnectionTab tab) {
        this.tabber.addTab(tab);
    }

    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        for (int i = 0; i < this.tabber.getTabCount(); ++i) {
            ((SshToolsConnectionTab)this.tabber.getTabAt(i)).setConnectionProfile(profile);
        }
    }

    public static SshToolsConnectionProfile showConnectionDialog(Component parent, SshToolsConnectionTab[] optionalTabs) {
        return SshToolsConnectionPanel.showConnectionDialog(parent, null, optionalTabs);
    }

    public static SshToolsConnectionProfile showConnectionDialog(Component parent, SshToolsConnectionProfile profile, SshToolsConnectionTab[] optionalTabs) {
        if (profile == null) {
            int port = 2222;
            String port_S = Integer.toString(2222);
            port_S = PreferencesStore.get("sshterm.simple.connection.port", port_S);
            try {
                port = Integer.parseInt(port_S);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse the port number from defaults file (property namesshterm.simple.connection.port, property value= " + port_S + ").");
            }
            profile = new SshToolsConnectionProfile();
            profile.setHost(PreferencesStore.get("apps.connection.lastHost", ""));
            profile.setPort(PreferencesStore.getInt("apps.connection.lastPort", port));
            profile.setUsername(PreferencesStore.get("apps.connection.lastUser", ""));
            profile.setPKCS12_Location(PreferencesStore.get("sshterm.pkcs12.defaults.file", ""));
        }
        final SshToolsConnectionPanel conx = new SshToolsConnectionPanel(true);
        if (optionalTabs != null) {
            for (int i = 0; i < optionalTabs.length; ++i) {
                conx.addTab(optionalTabs[i]);
            }
        }
        conx.setConnectionProfile(profile);
        JDialog d = null;
        Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, parent);
        d = w instanceof JDialog ? new JDialog((JDialog)w, "Connection Profile", true) : (w instanceof JFrame ? new JDialog((JFrame)w, "Connection Profile", true) : new JDialog((Frame)null, "Connection Profile", true));
        final JDialog dialog = d;
        class UserAction {
            boolean connect;

            UserAction() {
            }
        }
        final UserAction userAction = new UserAction();
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic('c');
        cancel.addActionListener(new ActionListener(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                userAction.connect = false;
                dialog.setVisible(false);
            }
        });
        JButton connect = new JButton("Connect");
        connect.setMnemonic('t');
        connect.addActionListener(new ActionListener(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (conx.validateTabs()) {
                    userAction.connect = true;
                    dialog.setVisible(false);
                }
            }
        });
        dialog.getRootPane().setDefaultButton(connect);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(6, 6, 0, 0);
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(buttonPanel, connect, gbc, -1);
        UIUtil.jGridBagAdd(buttonPanel, cancel, gbc, 0);
        JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
        southPanel.add(buttonPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)conx, "Center");
        mainPanel.add((Component)southPanel, "South");
        dialog.getContentPane().setLayout(new GridLayout(1, 1));
        dialog.getContentPane().add(mainPanel);
        dialog.pack();
        dialog.setResizable(false);
        UIUtil.positionComponent(0, dialog);
        SshToolsSimpleConnectionPrompt stscp = SshToolsSimpleConnectionPrompt.getInstance();
        StringBuffer sb = new StringBuffer();
        userAction.connect = !stscp.getHostname(sb, profile.getHost());
        boolean advanced = stscp.getAdvanced();
        if (advanced) {
            userAction.connect = false;
            profile.setHost(sb.toString());
            conx.hosttab.setConnectionProfile(profile);
            dialog.setVisible(true);
        }
        if (!userAction.connect) {
            return null;
        }
        conx.applyTabs();
        if (!advanced) {
            profile.setHost(sb.toString());
        }
        if (!advanced) {
            int port = 2222;
            String port_S = Integer.toString(2222);
            port_S = PreferencesStore.get("sshterm.simple.connection.port", port_S);
            try {
                port = Integer.parseInt(port_S);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse the port number from defaults file (property namesshterm.simple.connection.port, property value= " + port_S + ").");
            }
            profile.setPort(port);
        }
        if (!advanced) {
            profile.setUsername("");
        }
        PreferencesStore.put("apps.connection.lastUser", profile.getUsername());
        PreferencesStore.put("sshterm.pkcs12.defaults.file", profile.getApplicationProperty("sshterm.pkcs12.defaults.file", ""));
        PreferencesStore.put("sshterm.auth.order", profile.getApplicationProperty("sshterm.auth.order", ""));
        PreferencesStore.put("apps.connection.lastHost", profile.getHost());
        PreferencesStore.put("sshterm.myproxy.defaults.username", profile.getApplicationProperty("sshterm.myproxy.defaults.username", ""));
        PreferencesStore.put("sshterm.proxy.save", profile.getApplicationProperty("sshterm.proxy.save", ""));
        PreferencesStore.put("apps.connection.lastUser", profile.getUsername());
        PreferencesStore.putInt("apps.connection.lastPort", profile.getPort());
        PreferencesStore.put("sshterm.voms.support", profile.getApplicationProperty("sshterm.voms.support", ""));
        return profile;
    }
}

