/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.vomanagementtool;

import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.vomanagementtool.JTreeNodeDynamic;
import com.sshtools.common.vomanagementtool.common.ConfigHelper;
import com.sshtools.common.vomanagementtool.common.VOHelper;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class MyTree
extends JTree
implements Autoscroll,
ActionListener {
    private Insets insets;
    private int top = 0;
    private int bottom = 0;
    private int topRow = 0;
    private int bottomRow = 0;
    private JPopupMenu popupMenu;

    public MyTree(final boolean isFavourite) {
        this.setModel(this.treeModel);
        this.setShowsRootHandles(true);
        this.setEditable(true);
        this.setDragEnabled(true);
        this.getSelectionModel().setSelectionMode(4);
        final MyTree thisTree = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    TreePath tp = thisTree.getClosestPathForLocation(evt.getX(), evt.getY());
                    if (thisTree.getSelectionPath() != null && tp.equals(thisTree.getSelectionPath())) {
                        if (evt.getButton() == 1) {
                            JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
                            if (evt.getClickCount() == 2 && ConfigHelper.isAuthentication() && node.isLeaf()) {
                                if (ConfigHelper.selectedRoot.getChildCount() == 0) {
                                    ConfigHelper.selectedTreeModel.insertNodeInto(node, ConfigHelper.selectedRoot, 0);
                                } else {
                                    boolean isAdded = false;
                                    for (int i = 0; i < ConfigHelper.selectedRoot.getChildCount(); ++i) {
                                        JTreeNodeDynamic.MyTreeNode temp = (JTreeNodeDynamic.MyTreeNode)ConfigHelper.selectedRoot.getChildAt(i);
                                        if (!temp.getUserObject().toString().equals(node.getUserObject().toString())) continue;
                                        isAdded = true;
                                    }
                                    if (!isAdded) {
                                        ConfigHelper.selectedTreeModel.insertNodeInto(node, ConfigHelper.selectedRoot, ConfigHelper.selectedRoot.getChildCount());
                                    }
                                }
                            }
                        } else if (evt.getButton() == 3) {
                            JMenuItem item;
                            JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
                            MyTree.this.popupMenu = new JPopupMenu();
                            if (evt.getSource() == ConfigHelper.selectedTree) {
                                item = new JMenuItem("Clear");
                                item.setActionCommand("clear");
                                item.addActionListener(thisTree);
                                MyTree.this.popupMenu.add(item);
                            }
                            if (!ConfigHelper.isAuthentication()) {
                                if (isFavourite) {
                                    if (!node.isLeaf()) {
                                        item = new JMenuItem("Add VO");
                                        item.setActionCommand("addVo");
                                        item.addActionListener(thisTree);
                                        MyTree.this.popupMenu.add(item);
                                    } else {
                                        item = new JMenuItem("Remove from Favourites");
                                        item.setActionCommand("removeFav");
                                        item.addActionListener(thisTree);
                                        MyTree.this.popupMenu.add(item);
                                    }
                                } else if (node.isLeaf()) {
                                    item = new JMenuItem("Add to Favourites");
                                    item.setActionCommand("addFav");
                                    item.addActionListener(thisTree);
                                    MyTree.this.popupMenu.add(item);
                                }
                            }
                            if (node.isLeaf()) {
                                item = new JMenuItem("Show details");
                                item.setActionCommand("show");
                                item.addActionListener(thisTree);
                                MyTree.this.popupMenu.add(item);
                            }
                            MyTree.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = MyTree.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        TreePath tp = this.getSelectionPath();
        if (evt.getActionCommand().equals("addVo")) {
            if (VOHelper.createAddVODialog()) {
                JOptionPane.showMessageDialog(null, "Successfully created new VO.", "Add new VO:", 1, new ResourceIcon(this.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"));
            }
            JTreeNodeDynamic.MyTreeNode myNode = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            if (VOHelper.retrieveSetup()) {
                myNode.loadChildren(model, "Favourites", true);
            }
        } else if (evt.getActionCommand().equals("removeFav")) {
            String voname = tp.getLastPathComponent().toString();
            int result = JOptionPane.showConfirmDialog(null, "Are sure you want to remove '" + voname + "' from " + "Favourites" + "?", "Remove VO from Favourites", 2, 3, new ResourceIcon(this.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"));
            if (result == 0 && VOHelper.removeVOFromFavourites(voname)) {
                JTreeNodeDynamic.MyTreeNode parentNode = (JTreeNodeDynamic.MyTreeNode)tp.getParentPath().getLastPathComponent();
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                if (VOHelper.retrieveSetup()) {
                    parentNode.loadChildren(model, "Favourites", true);
                }
            }
        } else if (evt.getActionCommand().equals("addFav")) {
            String voname = tp.getLastPathComponent().toString();
            int result = JOptionPane.showConfirmDialog(null, "Are sure you want to add existing VO '" + voname + "' to " + "Favourites" + "?", "Add existing VO to Favourites", 2, 3, new ResourceIcon(this.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"));
            if (result == 0 && VOHelper.addVOToFavourites(voname, tp.getParentPath().getLastPathComponent().toString())) {
                JTreeNodeDynamic.MyTreeNode parentNode = (JTreeNodeDynamic.MyTreeNode)tp.getParentPath().getLastPathComponent();
                DefaultTreeModel model = (DefaultTreeModel)ConfigHelper.favTree.getModel();
                if (VOHelper.retrieveSetup()) {
                    ConfigHelper.favRoot.loadChildren(model, "Favourites", true);
                }
            }
        } else if (evt.getActionCommand().equals("show")) {
            if (tp.getLastPathComponent() instanceof JTreeNodeDynamic.MyTreeNode) {
                JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
                List voDetails = node.getNodeVODetails();
                String msg = "Local VO name: " + tp.getLastPathComponent().toString() + "\n";
                for (int i = 0; i < voDetails.size(); ++i) {
                    TreeMap details = (TreeMap)voDetails.get(i);
                    msg = voDetails.size() > 1 ? msg + "\t(" + (i + 1) + ")\n" + "\t\t\tServer: " + details.get("server") + "\n" + "\t\t\tPort: " + details.get("port") + "\n" + "\t\t\tDN: " + details.get("dn") + "\n" + "\t\t\tServer VO name: " + details.get("servervoname") + "\n" : msg + "\t\tServer: " + details.get("server") + "\n" + "\t\tPort: " + details.get("port") + "\n" + "\t\tDN: " + details.get("dn") + "\n" + "\t\tServer VO name: " + details.get("servervoname") + "\n";
                }
                JOptionPane.showMessageDialog(null, msg, "VO Information:", 1, new ResourceIcon(this.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"));
            }
        } else if (evt.getActionCommand().equals("clear") && tp.getLastPathComponent() instanceof JTreeNodeDynamic.MyTreeNode) {
            JTreeNodeDynamic.MyTreeNode node = (JTreeNodeDynamic.MyTreeNode)tp.getLastPathComponent();
            ConfigHelper.selectedTreeModel.removeNodeFromParent(node);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = Math.max(ConfigHelper.getPreferredWidth(), preferredSize.width);
        preferredSize.height = Math.max(ConfigHelper.getPreferredHeight(), preferredSize.height);
        return preferredSize;
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.insets;
    }

    @Override
    public void autoscroll(Point p) {
        this.top = Math.abs(this.getLocation().y) + 10;
        this.bottom = this.top + this.getParent().getHeight() - 20;
        if (p.y < this.top) {
            int next = this.topRow--;
            ++this.bottomRow;
            this.scrollRowToVisible(next);
        } else if (p.y > this.bottom) {
            int next = this.bottomRow++;
            --this.topRow;
            this.scrollRowToVisible(next);
        }
    }
}

