/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.vomanagementtool;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.vomanagementtool.JTreeNodeDynamic;
import com.sshtools.common.vomanagementtool.VOManagementToolPanel;
import com.sshtools.common.vomanagementtool.VOSelectedPanel;
import com.sshtools.common.vomanagementtool.common.ConfigHelper;
import com.sshtools.common.vomanagementtool.common.VOHelper;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.glite.voms.contact.UserCredentials;
import org.glite.voms.contact.VOMSProxyInit;
import org.glite.voms.contact.VOMSRequestOptions;
import org.globus.common.CoGProperties;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.util.ConfigUtil;
import org.globus.util.Util;
import org.ietf.jgss.GSSException;

public class VOAuthenticationDialogPrompt {
    private static VOAuthenticationDialogPrompt instance;
    private Component parent;
    private String title = "VOMS-PROXY-INIT";

    public VOAuthenticationDialog getVOMSAuthenticated() {
        Window window = this.parent != null ? (Window)SwingUtilities.getAncestorOfClass(Window.class, this.parent) : null;
        VOAuthenticationDialog dialog = null;
        dialog = window instanceof Frame ? new VOAuthenticationDialog((Frame)window) : (window instanceof Dialog ? new VOAuthenticationDialog((Dialog)window) : new VOAuthenticationDialog());
        return dialog;
    }

    private VOAuthenticationDialogPrompt() {
    }

    public void setParentComponent(Component component) {
        this.parent = component;
    }

    public static VOAuthenticationDialogPrompt getInstance() {
        if (instance == null) {
            instance = new VOAuthenticationDialogPrompt();
        }
        return instance;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public class VOAuthenticationDialog
    extends JDialog
    implements ActionListener {
        String userName;
        String hostName;
        int port;
        int lifetime;
        String certType;
        String dn;
        boolean voms;
        JLabel promptLabel;
        VOManagementToolPanel vopanel;
        JButton vomsproxyinit;
        int proxyType;

        void init() {
            try {
                ConfigurationLoader.initialize(false);
            }
            catch (ConfigurationException ex) {
                // empty catch block
            }
            this.setIconImage(new ResourceIcon(this.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png").getImage());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PreferencesStore.put("sshterm.voms.proxyType", VOAuthenticationDialog.this.proxyType + "");
                }
            });
            try {
                VOHelper.checkUpdateVOMSConfigFiles();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error: Cannot fetch latest VOs setup", 0);
            }
            if (VOHelper.retrieveSetup()) {
                VOHelper.checkFavouritesChanges();
            } else {
                System.err.println("Retrieve setup failed!");
            }
            ConfigHelper.setAuthentication(true);
            JPanel iconPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(0, 2, 4, 2);
            gbc.weightx = 0.0;
            JLabel VOTitleLabel = new JLabel("Create voms enabled proxy");
            VOTitleLabel.setFont(new Font("Serif", 1, 16));
            UIUtil.jGridBagAdd(iconPanel, VOTitleLabel, gbc, -1);
            gbc.weightx = 1.0;
            IconWrapperPanel northPanel = new IconWrapperPanel(new ResourceIcon(this.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"), iconPanel);
            northPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            ConfigHelper.setVisibleRowCount(10);
            VOManagementToolPanel voPanel = new VOManagementToolPanel();
            JPanel centerPanel = new JPanel(new FlowLayout(0, 0, 0));
            centerPanel.add(voPanel);
            VOSelectedPanel voSelectedPanel = new VOSelectedPanel();
            JPanel eastPanel = new JPanel(new FlowLayout(0, 0, 0));
            eastPanel.add(voSelectedPanel);
            JPanel mainPanel = new JPanel(new BorderLayout());
            JScrollPane mainScroller = new JScrollPane(mainPanel);
            mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            mainPanel.add((Component)northPanel, "North");
            mainPanel.add((Component)centerPanel, "Center");
            mainPanel.add((Component)eastPanel, "East");
            this.vomsproxyinit = new JButton("voms-proxy-init");
            this.vomsproxyinit.addActionListener(this);
            mainPanel.add((Component)this.vomsproxyinit, "South");
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(mainScroller);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.vomsproxyinit) {
                boolean toContinue = true;
                if (ConfigHelper.selectedRoot.getChildCount() == 0) {
                    int result = JOptionPane.showConfirmDialog(this, "No VOs are selected", "Warning", 0, 2, new ResourceIcon(VOHelper.class, "/com/sshtools/common/vomanagementtool/largeVO.png"));
                    if (result == 0) {
                        this.dispatchEvent(new WindowEvent(this, 201));
                    }
                } else {
                    ArrayList<String> selectedVOs = new ArrayList<String>();
                    for (int i = 0; i < ConfigHelper.selectedRoot.getChildCount(); ++i) {
                        JTreeNodeDynamic.MyTreeNode temp = (JTreeNodeDynamic.MyTreeNode)ConfigHelper.selectedRoot.getChildAt(i);
                        selectedVOs.add(temp.getUserObject().toString());
                    }
                    X509Credential x509Cred = this.initProxy(selectedVOs.toArray(new String[selectedVOs.size()]));
                    if (x509Cred != null) {
                        try {
                            x509Cred.verify();
                            GlobusGSSCredentialImpl vomsCredential = new GlobusGSSCredentialImpl(x509Cred, 1);
                            String warningMsg = "";
                            Vector voAttributes = VOMSValidator.parse((X509Certificate[])x509Cred.getCertificateChain());
                            if (voAttributes != null && voAttributes.size() > 0) {
                                for (int i = 0; i < voAttributes.size(); ++i) {
                                    VOMSAttribute att = (VOMSAttribute)voAttributes.get(i);
                                    if (att == null) continue;
                                    try {
                                        long vomsSecLeft = (att.getNotAfter().getTime() - System.currentTimeMillis()) / 1000L;
                                        long proxySecLeft = x509Cred.getTimeLeft();
                                        if (proxySecLeft <= vomsSecLeft) continue;
                                        long days = vomsSecLeft / 86400L;
                                        long hours = (vomsSecLeft -= days * 60L * 60L * 24L) / 3600L;
                                        long mins = (vomsSecLeft -= hours * 60L * 60L) / 60L;
                                        warningMsg = warningMsg + "Lifetime for VOMS extension has been reduced to \n" + days + " days " + hours + " hours " + mins + " minutes " + (vomsSecLeft -= mins * 60L) + " seconds\n" + " for VO: " + att.getVO() + "\n\n";
                                        continue;
                                    }
                                    catch (ParseException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (!warningMsg.trim().equals("")) {
                                    warningMsg = warningMsg + "Please note that this is a VOMS server restriction.\nPlease contact your VO admin for more information.";
                                    JOptionPane.showMessageDialog(this, warningMsg, "Warning: VOMS extension lifetime", 1, new ResourceIcon(this.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"));
                                }
                            }
                            this.saveProxy(x509Cred);
                            ConfigHelper.setVomsCredential(vomsCredential);
                            this.dispatchEvent(new WindowEvent(this, 201));
                        }
                        catch (GSSException e) {
                            e.printStackTrace();
                        }
                        catch (CredentialException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        private X509Credential initProxy(String[] voNames) {
            int proxyCode;
            X509Credential x509Cred = null;
            X509Credential vomsCred = null;
            int proxyTypeInt = 4;
            if (ConfigHelper.getGssCred() instanceof GlobusGSSCredentialImpl && ((proxyCode = (x509Cred = ((GlobusGSSCredentialImpl)ConfigHelper.getGssCred()).getX509Credential()).getProxyType().getCode()) == GSIConstants.CertificateType.GSI_2_PROXY.getCode() || proxyCode == GSIConstants.CertificateType.GSI_2_LIMITED_PROXY.getCode())) {
                proxyTypeInt = 2;
            }
            if (x509Cred != null) {
                VOHelper.setupVOMSProperties();
                System.setProperty("org.globus.gsi.version", proxyTypeInt + "");
                HashMap options = this.getVOMSRequestOptions(voNames);
                try {
                    System.out.println("vomsdir: " + System.getProperty("VOMSDIR"));
                    System.out.println("vomsesdir: " + System.getProperty("VOMSES_LOCATION"));
                    System.out.println("cadir: " + System.getProperty("CADIR"));
                    UserCredentials userCreds = UserCredentials.instance((PrivateKey)x509Cred.getPrivateKey(), (X509Certificate[])x509Cred.getCertificateChain());
                    VOMSProxyInit vomsProxyInit = VOMSProxyInit.instance((UserCredentials)userCreds);
                    vomsProxyInit.setProxyLifetime((int)x509Cred.getTimeLeft());
                    vomsProxyInit.setProxyType(proxyTypeInt);
                    UserCredentials vomsUserCred = vomsProxyInit.getVomsProxy(options.values());
                    vomsCred = new X509Credential(vomsUserCred.getUserKey(), vomsUserCred.getUserChain());
                    this.saveVOMSProxy(vomsCred);
                    JOptionPane.showMessageDialog(this, "Successfully created VOMS enabled proxy.", "GSI-SSHTerm Authentication", 1, new ResourceIcon(this.getClass(), "/com/sshtools/common/vomanagementtool/largeVO.png"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Failed to create VOMS enabled proxy.", "GSI-SSHTerm Authentication", 0);
                    return null;
                }
            }
            return vomsCred;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveVOMSProxy(X509Credential theProxy) {
            String proxyFile = CoGProperties.getDefault().getProxyFile();
            FileOutputStream out = null;
            String proxyLoc = ConfigUtil.discoverProxyLocation();
            try {
                out = new FileOutputStream(proxyLoc);
                theProxy.save(out);
                if (!Util.setOwnerAccessOnly(proxyLoc)) {
                    System.out.println("Warning: could not set permissions on proxy file.");
                }
                out.flush();
            }
            catch (FileNotFoundException e) {
                System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            }
            catch (CertificateEncodingException e) {
                System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Exception e) {}
                }
            }
        }

        private HashMap getVOMSRequestOptions(String[] fqans) {
            HashMap<String, VOMSRequestOptions> options = new HashMap<String, VOMSRequestOptions>();
            for (int i = 0; i < fqans.length; ++i) {
                VOMSRequestOptions voOpt;
                String[] opts = fqans[i].split(":");
                String voname = opts[0];
                if (options.containsKey(voname)) {
                    voOpt = (VOMSRequestOptions)options.get(voname);
                } else {
                    voOpt = new VOMSRequestOptions();
                    voOpt.setVoName(voname);
                    options.put(voname, voOpt);
                }
                if (opts.length != 2) continue;
                voOpt.addFQAN(opts[1]);
            }
            return options;
        }

        private void saveProxy(X509Credential proxy) {
            FileOutputStream out = null;
            String proxyLoc = ConfigUtil.discoverProxyLocation();
            try {
                out = new FileOutputStream(proxyLoc);
                proxy.save(out);
                if (!Util.setOwnerAccessOnly(proxyLoc)) {
                    System.out.println("Warning: could not set permissions on proxy file.");
                }
                out.flush();
            }
            catch (FileNotFoundException e) {
                System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            }
            catch (CertificateEncodingException e) {
                System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("Failed to save proxy to proxy file: " + e.getMessage());
            }
        }

        VOAuthenticationDialog() {
            super((Frame)null, VOAuthenticationDialogPrompt.this.title, true);
            this.userName = "";
            this.hostName = "";
            this.port = 0;
            this.lifetime = 0;
            this.certType = null;
            this.dn = null;
            this.voms = false;
            this.proxyType = 10;
            this.promptLabel = new JLabel();
            this.init();
        }

        VOAuthenticationDialog(Frame frame) {
            super(frame, VOAuthenticationDialogPrompt.this.title, true);
            this.userName = "";
            this.hostName = "";
            this.port = 0;
            this.lifetime = 0;
            this.certType = null;
            this.dn = null;
            this.voms = false;
            this.proxyType = 10;
            this.promptLabel = new JLabel();
            this.init();
        }

        VOAuthenticationDialog(Dialog dialog) {
            super(dialog, VOAuthenticationDialogPrompt.this.title, true);
            this.userName = "";
            this.hostName = "";
            this.port = 0;
            this.lifetime = 0;
            this.certType = null;
            this.dn = null;
            this.voms = false;
            this.proxyType = 10;
            this.promptLabel = new JLabel();
            this.init();
        }
    }
}

