/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public class GSSAPIKeyexAuthenticationClient
extends SshAuthenticationClient {
    int attempt = 0;
    private static Log log = LogFactory.getLog(GSSAPIKeyexAuthenticationClient.class);

    @Override
    public final String getMethodName() {
        return "gssapi-keyex";
    }

    @Override
    public void reset() {
        this.attempt = 0;
    }

    @Override
    public void authenticate(AuthenticationProtocolClient authenticationprotocolclient, String s) throws IOException, TerminatedStateException, IllegalArgumentException {
        try {
            if (this.attempt++ != 0) {
                throw new IllegalArgumentException();
            }
            GSSContext gsscontext = authenticationprotocolclient.getGSSContext();
            if (gsscontext == null) {
                throw new IllegalArgumentException();
            }
            log.debug("Creating GSS context base on grid credentials.");
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.writeBinaryString(authenticationprotocolclient.getSessionIdentifier());
            baw.write(50);
            baw.writeString(this.getUsername());
            baw.writeString(s);
            baw.writeString("gssapi-keyex");
            ByteArrayWriter mic = new ByteArrayWriter();
            mic.writeBinaryString(gsscontext.getMIC(baw.toByteArray(), 0, baw.toByteArray().length, null));
            log.debug("Sending gssapi-keyex user auth request.");
            SshMsgUserAuthRequest sshmsguserauthrequest = new SshMsgUserAuthRequest(this.getUsername(), s, "gssapi-keyex", mic.toByteArray());
            authenticationprotocolclient.sendMessage(sshmsguserauthrequest);
            log.debug("Receiving user auth response.");
        }
        catch (GSSException gssexception) {
            gssexception.printStackTrace();
            StringWriter stringwriter = new StringWriter();
            gssexception.printStackTrace(new PrintWriter(stringwriter));
            log.debug(stringwriter);
        }
    }

    @Override
    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        return properties;
    }

    @Override
    public void setPersistableProperties(Properties properties) {
    }

    @Override
    public boolean canAuthenticate() {
        return true;
    }
}

