/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.connection.BindingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingChannelImpl;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingBindingChannel
extends BindingChannel
implements ForwardingChannel {
    private static Log log = LogFactory.getLog(ForwardingSocketChannel.class);
    private ForwardingChannelImpl channel;

    public ForwardingBindingChannel(String forwardType, String name, String hostToConnectOrBind, int portToConnectOrBind, String originatingHost, int originatingPort) throws ForwardingConfigurationException {
        if (!(forwardType.equals("direct-tcpip") || forwardType.equals("forwarded-tcpip") || forwardType.equals("x11"))) {
            throw new ForwardingConfigurationException("The forwarding type is invalid");
        }
        this.channel = new ForwardingChannelImpl(forwardType, name, hostToConnectOrBind, portToConnectOrBind, originatingHost, originatingPort);
    }

    @Override
    public String getName() {
        return this.channel.getName();
    }

    @Override
    public byte[] getChannelOpenData() {
        return this.channel.getChannelOpenData();
    }

    @Override
    public byte[] getChannelConfirmationData() {
        return this.channel.getChannelConfirmationData();
    }

    @Override
    public String getChannelType() {
        return this.channel.getChannelType();
    }

    @Override
    protected int getMinimumWindowSpace() {
        return 32768;
    }

    @Override
    protected int getMaximumWindowSpace() {
        return 131072;
    }

    @Override
    protected int getMaximumPacketSize() {
        return 32768;
    }

    @Override
    public String getOriginatingHost() {
        return this.channel.getOriginatingHost();
    }

    @Override
    public int getOriginatingPort() {
        return this.channel.getOriginatingPort();
    }

    @Override
    public String getHostToConnectOrBind() {
        return this.channel.getHostToConnectOrBind();
    }

    @Override
    public int getPortToConnectOrBind() {
        return this.channel.getPortToConnectOrBind();
    }

    @Override
    protected void onChannelRequest(String request, boolean wantReply, byte[] requestData) throws IOException {
        this.connection.sendChannelRequestFailure(this);
    }
}

