/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XDisplay {
    private static Log log = LogFactory.getLog(XDisplay.class);
    private String host;
    private int display;
    private boolean isLocal;
    private String socketPath;

    private int parseDisplayNum(String display) {
        String rest = display.substring(display.indexOf(":") + 1);
        if (rest.charAt(0) == ':') {
            rest = rest.substring(1);
        }
        if (rest.indexOf(".") >= 0) {
            rest = rest.substring(0, rest.indexOf("."));
        }
        try {
            return Integer.parseInt(rest);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse display number from DISPLAY:" + display);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processDisplay(String display) {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        boolean linux = os.equals("Linux");
        boolean mac = os.equals("Mac OS X");
        if (display.startsWith("unix:") || display.charAt(0) == ':' || display.startsWith("/tmp/launch")) {
            this.isLocal = true;
            this.host = null;
            this.display = this.parseDisplayNum(display);
            if (mac) {
                this.socketPath = display;
                return;
            }
            if (linux) {
                this.socketPath = "/tmp/.X11-unix/X" + this.display;
                return;
            }
            log.debug("Can't determine Unix socket path for X11 forwarding on OS: " + os + " Architecture: " + arch);
            throw new IllegalArgumentException("Incompatible architecture/os for unix socket");
        }
        this.isLocal = false;
        if (display.indexOf(":") == -1) {
            throw new IllegalArgumentException("Could not find ':' in DISPLAY: " + display);
        }
        this.host = display.substring(0, display.indexOf(":"));
        this.display = this.parseDisplayNum(display);
    }

    public XDisplay() {
        try {
            String display = System.getenv("DISPLAY");
            if (display == null) {
                log.warn("Display not set, trying localhost:0.0");
                this.processDisplay("localhost:0.0");
            } else {
                this.processDisplay(display);
            }
        }
        catch (Error e) {
            if (!System.getProperty("os.name").startsWith("Window")) {
                try {
                    String cmd = "env";
                    log.debug("Executing " + cmd);
                    Process process = Runtime.getRuntime().exec(cmd);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = reader.readLine();
                    while (line != null) {
                        if (line.startsWith("DISPLAY=")) {
                            this.processDisplay(line.substring(8));
                            return;
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                    this.processDisplay(":0.0");
                    return;
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                    this.processDisplay(":0.0");
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    this.processDisplay(":0.0");
                    return;
                }
            }
            this.processDisplay("localhost:0.0");
        }
    }

    public XDisplay(String string) {
        this.processDisplay(string);
    }

    public void setString(String string) {
        this.processDisplay(string);
    }

    public int getPort() {
        return this.getDisplay() + 6000;
    }

    public void setHost(String host) {
        if (host == null) {
            host = null;
            this.isLocal = true;
        } else {
            this.host = host;
            this.isLocal = false;
        }
    }

    public void setDisplay(int display) {
        this.display = display;
    }

    public boolean isLocalUNIXSocket() {
        return this.isLocal;
    }

    public String getSocketPath() {
        return this.socketPath;
    }

    public String getHost() {
        return this.host;
    }

    public int getDisplay() {
        return this.display;
    }

    public String toString() {
        if (this.isLocal) {
            return ":" + this.getDisplay();
        }
        return this.getHost() + ":" + this.getDisplay();
    }
}

