/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import java.math.BigInteger;

public class KeyExchangeState {
    public static final int IN_PROGRESS = 0;
    public static final int COMPLETE = 1;
    public static final int FAILED = 2;
    private BigInteger secret;
    private String reason;
    private byte[] exchangeHash;
    private byte[] hostKey;
    private byte[] signature;
    private int state = 0;

    public final synchronized void setComplete(byte[] exchangeHash, byte[] hostKey, byte[] signature, BigInteger secret) {
        this.exchangeHash = exchangeHash;
        this.hostKey = hostKey;
        this.signature = signature;
        this.secret = secret;
        this.state = 1;
        this.notifyAll();
    }

    public byte[] getExchangeHash() {
        return this.exchangeHash;
    }

    public final synchronized void setFailed(String reason) {
        this.reason = reason;
        this.state = 2;
        this.notifyAll();
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public BigInteger getSecret() {
        return this.secret;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public synchronized int getState() {
        return this.state;
    }

    public final synchronized void waitForCompletion() {
        while (this.state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized String getFailureReason() {
        return this.reason;
    }
}

