/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.math.BigInteger;

public class SshMsgKexDhReply
extends SshMessage {
    protected static final int SSH_MSG_KEXDH_REPLY = 31;
    private BigInteger f;
    private byte[] hostKey;
    private byte[] signature;

    public SshMsgKexDhReply(byte[] hostKey, BigInteger f, byte[] signature) {
        super(31);
        this.hostKey = hostKey;
        this.f = f;
        this.signature = signature;
    }

    public SshMsgKexDhReply() {
        super(31);
    }

    public BigInteger getF() {
        return this.f;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    @Override
    public String getMessageName() {
        return "SSH_MSG_KEXDH_REPLY";
    }

    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeBinaryString(this.hostKey);
            baw.writeBigInteger(this.f);
            baw.writeBinaryString(this.signature);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error writing message data: " + ioe.getMessage());
        }
    }

    @Override
    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.hostKey = bar.readBinaryString();
            this.f = bar.readBigInteger();
            this.signature = bar.readBinaryString();
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error reading message data: " + ioe.getMessage());
        }
    }
}

