/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgKexGssError
extends SshMessage {
    protected static final int SSH_MSG_KEXGSS_ERROR = 34;
    private int major;
    private int minor;
    private String message;
    private String lang;

    public SshMsgKexGssError(int major, int minor, String message, String lang) {
        super(34);
        this.major = major;
        this.minor = minor;
        this.message = message;
        this.lang = lang;
    }

    public SshMsgKexGssError() {
        super(34);
    }

    public int getMinor() {
        return this.minor;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLangage() {
        return this.lang;
    }

    public int getMajor() {
        return this.major;
    }

    @Override
    public String getMessageName() {
        return "SSH_MSG_KEXGSS_ERROR";
    }

    @Override
    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeInt(this.major);
            baw.writeInt(this.minor);
            baw.writeString(this.message);
            baw.writeString(this.lang);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error writing message data: " + ioe.getMessage());
        }
    }

    @Override
    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.major = (int)bar.readInt();
            this.minor = (int)bar.readInt();
            this.message = bar.readString();
            this.lang = bar.readString();
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error reading message data: " + ioe.getMessage());
        }
    }
}

