/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.ui.AboutAction;
import com.sshtools.common.ui.ChangelogAction;
import com.sshtools.common.ui.ExitAction;
import com.sshtools.common.ui.NewWindowAction;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationFrame;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.sshterm.FullScreenAction;
import com.sshtools.sshterm.SshTerminalPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshTermFullScreenWindowContainer
extends JFrame
implements SshToolsApplicationContainer {
    private static final long VDU_EVENTS = 252L;
    protected StandardAction exitAction;
    protected StandardAction aboutAction;
    protected StandardAction changelogAction;
    protected StandardAction newWindowAction;
    protected StandardAction fullScreenAction;
    protected Log log = LogFactory.getLog(SshToolsApplicationFrame.class);
    private SshToolsApplicationPanel panel;
    private SshToolsApplication application;
    private JSeparator toolSeperator;

    @Override
    public void init(final SshToolsApplication application, SshToolsApplicationPanel panel) throws SshToolsApplicationException {
        this.invalidate();
        try {
            Method m = this.getClass().getMethod("setUndecorated", Boolean.TYPE);
            m.invoke((Object)this, Boolean.TRUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.panel = panel;
        this.application = application;
        ((SshTerminalPanel)panel).setToolsVisible(false);
        panel.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.exitAction = new ExitAction(application, this);
        panel.registerAction(this.exitAction);
        this.newWindowAction = new NewWindowAction(application);
        panel.registerAction(this.newWindowAction);
        this.aboutAction = new AboutAction(this, application);
        panel.registerAction(this.aboutAction);
        this.changelogAction = new ChangelogAction(this, application);
        panel.registerAction(this.changelogAction);
        this.fullScreenAction = new FullScreenActionImpl(application, this);
        panel.registerAction(this.fullScreenAction);
        this.getApplicationPanel().rebuildActionComponents();
        JPanel p = new JPanel(new BorderLayout());
        if (panel.getToolBar() != null) {
            JPanel t = new JPanel(new BorderLayout());
            t.add((Component)panel.getToolBar(), "North");
            this.toolSeperator = new JSeparator(0);
            t.add((Component)this.toolSeperator, "South");
            final SshToolsApplicationPanel pnl = panel;
            panel.getToolBar().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent evt) {
                    SshTermFullScreenWindowContainer.this.log.debug("Tool separator is now " + pnl.getToolBar().isVisible());
                    SshTermFullScreenWindowContainer.this.toolSeperator.setVisible(pnl.getToolBar().isVisible());
                }
            });
            p.add((Component)t, "North");
        }
        p.add((Component)panel, "Center");
        if (panel.getStatusBar() != null) {
            p.add((Component)panel.getStatusBar(), "South");
        }
        JPanel x = new JPanel(new BorderLayout());
        x.add((Component)((SshTerminalPanel)panel).getJMenuBar(), "North");
        x.add((Component)p, "Center");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(x);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                application.closeContainer(SshTermFullScreenWindowContainer.this);
            }
        });
        this.validate();
    }

    @Override
    public void setContainerTitle(String title) {
    }

    @Override
    public void setContainerVisible(boolean visible) {
        if (visible && !this.isContainerVisible()) {
            try {
                this.setVisible(true);
                GraphicsDevice device = this.panel.getGraphicsConfiguration().getDevice();
                Method m = device.getClass().getMethod("setFullScreenWindow", Window.class);
                m.invoke((Object)device, this);
                this.log.debug("Full screen container made visible");
                ((SshTerminalPanel)this.panel).setAutoHideTools(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error(e);
            }
        } else if (!visible && this.isContainerVisible()) {
            try {
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                Method m = device.getClass().getMethod("setFullScreenWindow", Window.class);
                m.invoke((Object)device, new Object[]{null});
                this.setVisible(false);
                this.log.debug("Full screen container made invisible");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error(e);
            }
        }
    }

    @Override
    public boolean isContainerVisible() {
        return this.isVisible();
    }

    @Override
    public SshToolsApplicationPanel getApplicationPanel() {
        return this.panel;
    }

    @Override
    public void closeContainer() {
        this.log.debug("Closing full screen container");
        ((SshTerminalPanel)this.panel).setAutoHideTools(false);
        this.getApplicationPanel().deregisterAction(this.newWindowAction);
        this.getApplicationPanel().deregisterAction(this.exitAction);
        this.getApplicationPanel().deregisterAction(this.aboutAction);
        this.getApplicationPanel().deregisterAction(this.changelogAction);
        this.getApplicationPanel().deregisterAction(this.fullScreenAction);
        this.getApplicationPanel().rebuildActionComponents();
        this.setContainerVisible(false);
        this.dispose();
    }

    @Override
    public Component getWindow() {
        return this;
    }

    class FullScreenActionImpl
    extends FullScreenAction {
        public FullScreenActionImpl(SshToolsApplication application, SshToolsApplicationContainer container) {
            super(application, container);
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(30));
        }
    }
}

