/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj;

import java.io.File;
import java.io.FileInputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;

public class Config {
    private Logger _logger = Logger.getLogger(Config.class.getName());
    private String _nic = null;
    private String _dCapDoor = null;
    private String _pnfsDir = null;
    private int _poolTimeout = 5;

    public Config() {
        this.initialize();
    }

    private void initialize() {
        block6: {
            String dCapConf = null;
            try {
                dCapConf = System.getenv("DCAPJ_CONFIG_FILE");
                if (dCapConf == null) {
                    this._logger.info("No post-configuration file for dCapJ");
                    return;
                }
                this._logger.info("DCAPJ_CONFIG_FILE environment variable is define; configuration from  this file will take precedence over default values");
                File propFile = new File(dCapConf);
                if (propFile.exists()) {
                    Properties prop = new Properties();
                    prop.load(new FileInputStream(propFile));
                    this._logger.info("Loaded dCap conf file " + dCapConf);
                    this._pnfsDir = prop.getProperty("pnfs.dir");
                    this._logger.fine("Config: pnfs dir = " + this._pnfsDir);
                    this._dCapDoor = prop.getProperty("dcapdoor.hostname");
                    this._logger.fine("Config: dCap host = " + this._dCapDoor);
                    this._nic = prop.getProperty("interface");
                    this._logger.fine("Config: local interface = " + this._nic);
                    String tmp = prop.getProperty("poolTimeout", "5");
                    try {
                        this._poolTimeout = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        this._poolTimeout = 5;
                    }
                    this._logger.fine("Config: pool timeout = " + this._poolTimeout);
                    break block6;
                }
                this._logger.warning("dCap configuration file doesn't exist " + dCapConf);
            }
            catch (Exception e) {
                this._logger.info("Unable to load configuration file; default values will be used");
            }
        }
    }

    public String getPnfsDir() {
        return this._pnfsDir;
    }

    public String getdCapDoor() {
        return this._dCapDoor;
    }

    public String getInterface() {
        if (this._nic != null) {
            return this._nic;
        }
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                Enumeration<InetAddress> ips = nic.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip.isLoopbackAddress() || !(ip instanceof Inet4Address)) continue;
                    this._nic = ip.getHostAddress();
                    return this._nic;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getPoolTimeout() {
        return this._poolTimeout;
    }

    public void setPoolTimeout(int timeout) {
        this._poolTimeout = timeout;
    }
}

