/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.BCGSS;

import edu.illinois.ncsa.BCGSS.GlobusTlsCipherFactory;
import edu.illinois.ncsa.BCGSS.GlobusTlsClient;
import edu.illinois.ncsa.BCGSS.TlsHandlerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.GlobusGSSException;
import org.globus.gsi.gssapi.GlobusGSSName;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.ProxyCertificateUtil;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class BCGSSContextImpl
implements ExtendedGSSContext {
    public static final int GSI_WRAP = 26;
    private static final int GSI_SEQUENCE_SIZE = 8;
    private static final int GSI_MESSAGE_DIGEST_PADDING = 12;
    private static final byte[] SSLHANDSHAKE_PAD_1 = new byte[]{54};
    private static final String[] NO_ENCRYPTION = new String[]{"SSL_RSA_WITH_NULL_MD5"};
    private static final String[] ENABLED_PROTOCOLS = new String[]{"TLSv1", "SSLv3"};
    private static final byte[] DELEGATION_TOKEN = new byte[]{68};
    protected int state = 0;
    private static final int HANDSHAKE = 0;
    private static final int CLIENT_START_DEL = 2;
    private static final int CLIENT_END_DEL = 3;
    private static final int SERVER_START_DEL = 4;
    private static final int SERVER_END_DEL = 5;
    protected int delegationState = 0;
    private static final int DELEGATION_START = 0;
    private static final int DELEGATION_SIGN_CERT = 1;
    private static final int DELEGATION_COMPLETE_CRED = 2;
    protected boolean delegationFinished = false;
    protected boolean credentialDelegation = false;
    protected boolean anonymity = false;
    protected boolean encryption = false;
    protected boolean established = false;
    protected GSSName sourceName = null;
    protected GSSName targetName = null;
    protected GSIConstants.DelegationType delegationType = GSIConstants.DelegationType.LIMITED;
    protected Integer gssMode = GSIConstants.MODE_GSI;
    protected Boolean checkContextExpiration = Boolean.FALSE;
    protected Boolean rejectLimitedProxy = Boolean.FALSE;
    protected Boolean requireClientAuth = Boolean.TRUE;
    protected Boolean acceptNoClientCerts = Boolean.FALSE;
    protected Boolean requireAuthzWithDelegation = Boolean.TRUE;
    protected GlobusGSSCredentialImpl ctxCred;
    protected GSSName expectedTargetName = null;
    protected Date goodUntil = null;
    protected boolean conn = false;
    protected BouncyCastleCertProcessingFactory certFactory;
    protected Map proxyPolicyHandlers;
    protected Boolean peerLimited = null;
    private TlsHandlerUtil tlsHU = null;
    private GlobusTlsClient tlsClient = null;
    private GlobusTlsCipherFactory cipherFactory = null;

    public BCGSSContextImpl(GSSName target, GlobusGSSCredentialImpl cred) throws GSSException {
        if (cred == null) {
            throw new GSSException(13);
        }
        this.expectedTargetName = target;
        this.ctxCred = cred;
    }

    private void init() throws GlobusGSSException {
        this.certFactory = BouncyCastleCertProcessingFactory.getDefault();
        this.state = 0;
        try {
            this.cipherFactory = new GlobusTlsCipherFactory();
            this.tlsClient = new GlobusTlsClient(this.ctxCred.getX509Credential(), this.cipherFactory);
        }
        catch (Exception e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        this.tlsHU = new TlsHandlerUtil(this.tlsClient);
    }

    private X509Certificate bcConvert(X509Certificate cert) throws GSSException {
        if (!(cert instanceof X509CertificateObject)) {
            try {
                return CertificateLoadUtil.loadCertificate(new ByteArrayInputStream(cert.getEncoded()));
            }
            catch (Exception e) {
                throw new GlobusGSSException(11, (Throwable)e);
            }
        }
        return cert;
    }

    private void handshakeFinished() throws IOException {
        this.encryption = true;
    }

    private void setDone() {
        this.established = true;
    }

    private void setGoodUntil(Date date) {
        if (this.goodUntil == null) {
            this.goodUntil = date;
        } else if (date.before(this.goodUntil)) {
            this.goodUntil = date;
        }
    }

    protected void checkContext() throws GSSException {
        if (!this.conn || !this.isEstablished()) {
            throw new GSSException(12);
        }
        if (this.checkContextExpiration.booleanValue() && this.getLifetime() <= 0) {
            throw new GSSException(7);
        }
    }

    protected void setGssMode(Object value) throws GSSException {
        if (!(value instanceof Integer)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"GSS mode", Integer.class});
        }
        Integer v = (Integer)value;
        if (!v.equals(GSIConstants.MODE_GSI) && !v.equals(GSIConstants.MODE_SSL)) {
            throw new GlobusGSSException(11, 101, "badGssMode");
        }
        this.gssMode = v;
    }

    protected void setDelegationType(Object value) throws GSSException {
        GSIConstants.DelegationType v;
        if (value instanceof GSIConstants.DelegationType) {
            v = (GSIConstants.DelegationType)((Object)value);
        } else if (value instanceof Integer) {
            v = GSIConstants.DelegationType.get((Integer)value);
        } else {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"delegation type", GSIConstants.DelegationType.class});
        }
        if (v != GSIConstants.DelegationType.FULL && v != GSIConstants.DelegationType.LIMITED) {
            throw new GlobusGSSException(11, 101, "badDelegType");
        }
        this.delegationType = v;
    }

    protected void setCheckContextExpired(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"check context expired", Boolean.class});
        }
        this.checkContextExpiration = (Boolean)value;
    }

    protected void setRejectLimitedProxy(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"reject limited proxy", Boolean.class});
        }
        this.rejectLimitedProxy = (Boolean)value;
    }

    protected void setRequireClientAuth(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"require client auth", Boolean.class});
        }
        this.requireClientAuth = (Boolean)value;
    }

    protected void setRequireAuthzWithDelegation(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"require authz with delehation", Boolean.class});
        }
        this.requireAuthzWithDelegation = (Boolean)value;
    }

    protected void setAcceptNoClientCerts(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"accept no client certs", Boolean.class});
        }
        this.acceptNoClientCerts = (Boolean)value;
    }

    protected void setProxyPolicyHandlers(Object value) throws GSSException {
        if (!(value instanceof Map)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"Proxy policy handlers", Map.class});
        }
        this.proxyPolicyHandlers = (Map)value;
    }

    public void setOption(Oid option, Object value) throws GSSException {
        if (option == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (value == null) {
            throw new GlobusGSSException(11, 7, "nullOptionValue");
        }
        if (option.equals(GSSConstants.GSS_MODE)) {
            this.setGssMode(value);
        } else if (option.equals(GSSConstants.DELEGATION_TYPE)) {
            this.setDelegationType(value);
        } else if (option.equals(GSSConstants.CHECK_CONTEXT_EXPIRATION)) {
            this.setCheckContextExpired(value);
        } else if (option.equals(GSSConstants.REJECT_LIMITED_PROXY)) {
            this.setRejectLimitedProxy(value);
        } else if (option.equals(GSSConstants.REQUIRE_CLIENT_AUTH)) {
            this.setRequireClientAuth(value);
        } else {
            if (option.equals(GSSConstants.TRUSTED_CERTIFICATES)) {
                throw new GSSException(16);
            }
            if (option.equals(GSSConstants.PROXY_POLICY_HANDLERS)) {
                this.setProxyPolicyHandlers(value);
            } else if (option.equals(GSSConstants.ACCEPT_NO_CLIENT_CERTS)) {
                this.setAcceptNoClientCerts(value);
            } else if (option.equals(GSSConstants.AUTHZ_REQUIRED_WITH_DELEGATION)) {
                this.setRequireAuthzWithDelegation(value);
            } else {
                throw new GlobusGSSException(11, 37, "unknownOption", new Object[]{option});
            }
        }
    }

    public Object getOption(Oid option) throws GSSException {
        if (option == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (option.equals(GSSConstants.GSS_MODE)) {
            return this.gssMode;
        }
        if (option.equals(GSSConstants.DELEGATION_TYPE)) {
            return this.delegationType;
        }
        if (option.equals(GSSConstants.CHECK_CONTEXT_EXPIRATION)) {
            return this.checkContextExpiration;
        }
        if (option.equals(GSSConstants.REJECT_LIMITED_PROXY)) {
            return this.rejectLimitedProxy;
        }
        if (option.equals(GSSConstants.REQUIRE_CLIENT_AUTH)) {
            return this.requireClientAuth;
        }
        if (option.equals(GSSConstants.TRUSTED_CERTIFICATES)) {
            throw new GSSException(16);
        }
        if (option.equals(GSSConstants.PROXY_POLICY_HANDLERS)) {
            throw new GSSException(16);
        }
        if (option.equals(GSSConstants.ACCEPT_NO_CLIENT_CERTS)) {
            return this.acceptNoClientCerts;
        }
        return null;
    }

    public byte[] initDelegation(GSSCredential credential, Oid mechanism, int lifetime, byte[] buf, int off, int len) throws GSSException {
        return new byte[0];
    }

    public byte[] acceptDelegation(int i, byte[] bytes, int i1, int i2) throws GSSException {
        throw new GSSException(16);
    }

    public GSSCredential getDelegatedCredential() {
        return null;
    }

    public boolean isDelegationFinished() {
        return this.delegationFinished;
    }

    public Object inquireByOid(Oid oid) throws GSSException {
        if (oid == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (oid.equals(GSSConstants.X509_CERT_CHAIN)) {
            if (this.isEstablished()) {
                try {
                    Object peerCerts = null;
                    if (peerCerts != null && (peerCerts).length > 0) {
                        return peerCerts;
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new GlobusGSSException(9, (Throwable)e);
                }
            }
        } else if (oid.equals(GSSConstants.RECEIVED_LIMITED_PROXY)) {
            return this.peerLimited;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] initSecContext(byte[] inBuff, int off, int len) throws GSSException {
        if (!this.conn) {
            if (this.credentialDelegation) {
                if (this.gssMode.equals(GSIConstants.MODE_SSL)) {
                    throw new GlobusGSSException(11, 7, "initCtx00");
                }
                if (this.anonymity) {
                    throw new GlobusGSSException(11, 7, "initCtx01");
                }
            }
            if (this.anonymity || this.ctxCred.getName().isAnonymous()) {
                this.anonymity = true;
            } else {
                this.anonymity = false;
                if (this.ctxCred.getUsage() != 1 && this.ctxCred.getUsage() != 0) {
                    throw new GlobusGSSException(9, 102, "badCredUsage");
                }
            }
            this.init();
            this.conn = true;
        }
        if (!Boolean.FALSE.equals(this.requireAuthzWithDelegation) && this.expectedTargetName == null && this.credentialDelegation) {
            throw new GlobusGSSException(11, 7, "initCtx02");
        }
        returnToken = null;
        switch (this.state) {
            case 0: {
                try {
                    returnToken = this.tlsHU.nextHandshakeToken(inBuff);
                    if (!this.tlsHU.isHandshakeFinished()) break;
                    this.handshakeFinished();
                    chain = this.tlsClient.getPeerCerts();
                    if (!(chain instanceof X509Certificate[])) {
                        throw new Exception("Certificate chain not of type X509Certificate");
                    }
                    for (X509Certificate cert : chain) {
                        this.setGoodUntil(cert.getNotAfter());
                    }
                    identity = BouncyCastleUtil.getIdentity(this.bcConvert(BouncyCastleUtil.getIdentityCertificate(chain)));
                    this.targetName = new GlobusGSSName(CertificateUtil.toGlobusID(identity, false));
                    this.peerLimited = ProxyCertificateUtil.isLimitedProxy(BouncyCastleUtil.getCertificateType(chain[0]));
                    if (this.anonymity) {
                        this.sourceName = new GlobusGSSName();
                    } else {
                        for (X509Certificate cert : this.ctxCred.getCertificateChain()) {
                            this.setGoodUntil(cert.getNotAfter());
                        }
                        this.sourceName = this.ctxCred.getName();
                    }
                    if (this.expectedTargetName != null && !this.expectedTargetName.equals(this.targetName)) {
                        throw new GlobusGSSException(15, 25, "authFailed00", new Object[]{this.expectedTargetName, this.targetName});
                    }
                    if (!this.gssMode.equals(GSIConstants.MODE_GSI)) ** GOTO lbl47
                    this.state = 2;
                    if (returnToken != null && returnToken.length > 0) {
                        break;
                    }
                    ** GOTO lbl53
lbl47:
                    // 1 sources

                    this.setDone();
                    break;
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (Exception e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
lbl53:
            // 2 sources

            case 2: {
                if (this.state != 2 || returnToken != null && returnToken.length > 0) {
                    throw new GSSException(11);
                }
                try {
                    if (this.getCredDelegState()) {
                        deleg = Character.toString('D');
                        this.state = 3;
                    } else {
                        deleg = Character.toString('0');
                        this.setDone();
                    }
                    a = deleg.getBytes();
                    returnToken = this.tlsHU.wrap(a);
                    break;
                }
                catch (Exception e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
            case 3: {
                if (inBuff == null || inBuff.length == 0) {
                    throw new GSSException(10);
                }
                try {
                    certReq = this.tlsHU.unwrap(inBuff);
                    if (certReq.length == 0) break;
                    chain = this.ctxCred.getCertificateChain();
                    cert = this.certFactory.createCertificate((InputStream)new ByteArrayInputStream(certReq), chain[0], this.ctxCred.getPrivateKey(), -1, BouncyCastleCertProcessingFactory.decideProxyType(chain[0], this.delegationType));
                    enc = cert.getEncoded();
                    returnToken = this.tlsHU.wrap(enc);
                    this.setDone();
                    break;
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
            default: {
                throw new GSSException(11);
            }
        }
        if (returnToken != null && returnToken.length > 0 || this.state == 2) {
            return returnToken;
        }
        return null;
    }

    public int initSecContext(InputStream in, OutputStream out) throws GSSException {
        byte[] inToken = null;
        try {
            inToken = !this.conn ? new byte[]{} : SSLUtil.readSslMessage(in);
            byte[] outToken = this.initSecContext(inToken, 0, inToken.length);
            if (outToken != null) {
                out.write(outToken);
                return outToken.length;
            }
            return 0;
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    public byte[] acceptSecContext(byte[] bytes, int i, int i1) throws GSSException {
        throw new GSSException(16);
    }

    public void acceptSecContext(InputStream in, OutputStream out) throws GSSException {
        throw new GSSException(16);
    }

    public boolean isEstablished() {
        return this.established;
    }

    public void dispose() throws GSSException {
    }

    public int getWrapSizeLimit(int i, boolean b, int i1) throws GSSException {
        throw new GSSException(16);
    }

    public byte[] wrap(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        this.checkContext();
        byte[] token = null;
        boolean doGSIWrap = false;
        if (prop != null) {
            if (prop.getQOP() != 0 && prop.getQOP() != 1) {
                throw new GSSException(14);
            }
            boolean bl = doGSIWrap = !prop.getPrivacy() && prop.getQOP() == 1;
        }
        if (doGSIWrap) {
            throw new GSSException(16);
        }
        try {
            token = this.tlsHU.wrap(inBuf, off, len);
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        if (prop != null) {
            prop.setPrivacy(this.encryption);
            prop.setQOP(0);
        }
        return token;
    }

    public void wrap(InputStream in, OutputStream out, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public byte[] unwrap(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        this.checkContext();
        byte[] token = null;
        if (inBuf[off] == 26 && inBuf[off + 1] == 3 && inBuf[off + 2] == 0) {
            throw new GSSException(16);
        }
        try {
            token = this.tlsHU.unwrap(inBuf, off, len);
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        if (prop != null) {
            prop.setPrivacy(this.encryption);
            prop.setQOP(0);
        }
        return token;
    }

    public void unwrap(InputStream in, OutputStream out, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public byte[] getMIC(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        this.checkContext();
        if (prop != null && (prop.getQOP() != 0 || prop.getPrivacy())) {
            throw new GSSException(14);
        }
        long sequence = this.cipherFactory.getTlsBlockCipher().getWriteMac().getSequenceNumber();
        int md_size = this.cipherFactory.getDigest().getDigestSize();
        byte[] mic = new byte[12 + md_size];
        System.arraycopy(BCGSSContextImpl.toBytes(sequence), 0, mic, 0, 8);
        System.arraycopy(BCGSSContextImpl.toBytes(len, 4), 0, mic, 8, 4);
        this.cipherFactory.getTlsBlockCipher().getWriteMac().incSequence();
        int pad_ct = 48 / md_size * md_size;
        try {
            MessageDigest md = MessageDigest.getInstance(this.cipherFactory.getDigest().getAlgorithmName());
            md.update(this.cipherFactory.getTlsBlockCipher().getWriteMac().getMACSecret());
            for (int i = 0; i < pad_ct; ++i) {
                md.update(SSLHANDSHAKE_PAD_1);
            }
            md.update(mic, 0, 12);
            md.update(inBuf, off, len);
            byte[] digest = md.digest();
            System.arraycopy(digest, 0, mic, 12, digest.length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        if (prop != null) {
            prop.setPrivacy(false);
            prop.setQOP(0);
        }
        return mic;
    }

    public void getMIC(InputStream in, OutputStream out, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void verifyMIC(byte[] inTok, int tokOff, int tokLen, byte[] inMsg, int msgOff, int msgLen, MessageProp prop) throws GSSException {
        long readSeq;
        this.checkContext();
        String digestAlg = this.cipherFactory.getDigest().getAlgorithmName();
        int md_size = this.cipherFactory.getDigest().getDigestSize();
        if (tokLen != 12 + md_size) {
            throw new GlobusGSSException(10, 29, "tokenFail00", new Object[]{new Integer(tokLen), new Integer(12 + md_size)});
        }
        int bufLen = SSLUtil.toInt(inTok, tokOff + 8);
        if (bufLen != msgLen) {
            throw new GlobusGSSException(10, 29, "tokenFail01", new Object[]{new Integer(msgLen), new Integer(bufLen)});
        }
        int pad_ct = 48 / md_size * md_size;
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlg);
            md.update(this.cipherFactory.getTlsBlockCipher().getReadMac().getMACSecret());
            for (int i = 0; i < pad_ct; ++i) {
                md.update(SSLHANDSHAKE_PAD_1);
            }
            md.update(inTok, tokOff, 12);
            md.update(inMsg, msgOff, msgLen);
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        byte[] token = new byte[tokLen - 12];
        System.arraycopy(inTok, tokOff + 12, token, 0, token.length);
        if (!Arrays.equals(digest, token)) {
            throw new GlobusGSSException(6, 33, "tokenFail02");
        }
        long tokSeq = SSLUtil.toLong(inTok, tokOff);
        long seqTest = tokSeq - (readSeq = this.cipherFactory.getTlsBlockCipher().getReadMac().getSequenceNumber());
        if (seqTest > 0L) {
            throw new GSSException(22);
        }
        if (seqTest < 0L) {
            throw new GSSException(20);
        }
        this.cipherFactory.getTlsBlockCipher().getReadMac().incSequence();
        if (prop != null) {
            prop.setPrivacy(false);
            prop.setQOP(0);
        }
    }

    public void verifyMIC(InputStream tokStream, InputStream msgStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public byte[] export() throws GSSException {
        throw new GSSException(16);
    }

    public void requestMutualAuth(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "mutualAuthOn");
        }
    }

    public void requestReplayDet(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "replayDet");
        }
    }

    public void requestSequenceDet(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "seqDet");
        }
    }

    public void requestCredDeleg(boolean state) throws GSSException {
        this.credentialDelegation = state;
    }

    public void requestAnonymity(boolean state) throws GSSException {
        this.anonymity = state;
    }

    public void requestConf(boolean state) throws GSSException {
        this.encryption = true;
    }

    public void requestInteg(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "integOn");
        }
    }

    public void requestLifetime(int lifetime) throws GSSException {
        if (lifetime == Integer.MAX_VALUE) {
            throw new GlobusGSSException(11, 102, "badLifetime00");
        }
        if (lifetime != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, lifetime);
            this.setGoodUntil(calendar.getTime());
        }
    }

    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        throw new GSSException(16);
    }

    public boolean getCredDelegState() {
        return this.credentialDelegation;
    }

    public boolean getMutualAuthState() {
        return true;
    }

    public boolean getReplayDetState() {
        return true;
    }

    public boolean getSequenceDetState() {
        return true;
    }

    public boolean getAnonymityState() {
        return this.anonymity;
    }

    public boolean isTransferable() throws GSSException {
        throw new GSSException(16);
    }

    public boolean isProtReady() {
        return this.isEstablished();
    }

    public boolean getConfState() {
        return this.encryption;
    }

    public boolean getIntegState() {
        return true;
    }

    public int getLifetime() {
        if (this.goodUntil != null) {
            return (int)((this.goodUntil.getTime() - System.currentTimeMillis()) / 1000L);
        }
        return -1;
    }

    public GSSName getSrcName() throws GSSException {
        return this.sourceName;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public Oid getMech() throws GSSException {
        return GSSConstants.MECH_OID;
    }

    public GSSCredential getDelegCred() throws GSSException {
        throw new GSSException(16);
    }

    public boolean isInitiator() throws GSSException {
        return true;
    }

    public static byte[] toBytes(long val) {
        return BCGSSContextImpl.toBytes(val, 8);
    }

    public static byte[] toBytes(short val) {
        return BCGSSContextImpl.toBytes(val, 2);
    }

    public static byte[] toBytes(long val, int bytes) {
        byte[] retval = new byte[bytes];
        while (bytes-- > 0) {
            retval[bytes] = (byte)(val & 0xFFL);
            val >>= 8;
        }
        return retval;
    }
}

