/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.esf;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Object;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import java.io.IOException;

public class OtherRevVals
extends ASN1Encodable {
    private DERObjectIdentifier otherRevValType;
    private ASN1Object otherRevVals;

    public static OtherRevVals getInstance(Object object) {
        if (null == object || object instanceof OtherRevVals) {
            return (OtherRevVals)object;
        }
        return new OtherRevVals((ASN1Sequence)object);
    }

    public OtherRevVals(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.otherRevValType = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        try {
            this.otherRevVals = ASN1Object.fromByteArray(aSN1Sequence.getObjectAt(1).getDERObject().getDEREncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public OtherRevVals(DERObjectIdentifier dERObjectIdentifier, ASN1Object aSN1Object) {
        this.otherRevValType = dERObjectIdentifier;
        this.otherRevVals = aSN1Object;
    }

    public DERObjectIdentifier getOtherRevValType() {
        return this.otherRevValType;
    }

    public ASN1Object getOtherRevVals() {
        return this.otherRevVals;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.otherRevValType);
        aSN1EncodableVector.add(this.otherRevVals);
        return new DERSequence(aSN1EncodableVector);
    }
}

