/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Encodable;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.esf.CommitmentTypeIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.esf.CommitmentTypeIndication;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;

public class CommitmentTypeIndicationUnitTest
extends SimpleTest {
    public String getName() {
        return "CommitmentTypeIndication";
    }

    public void performTest() throws Exception {
        CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(CommitmentTypeIdentifier.proofOfOrigin);
        this.checkConstruction(commitmentTypeIndication, CommitmentTypeIdentifier.proofOfOrigin, null);
        DERSequence dERSequence = new DERSequence(new DERObjectIdentifier("1.2"));
        commitmentTypeIndication = new CommitmentTypeIndication(CommitmentTypeIdentifier.proofOfOrigin, dERSequence);
        this.checkConstruction(commitmentTypeIndication, CommitmentTypeIdentifier.proofOfOrigin, dERSequence);
        commitmentTypeIndication = CommitmentTypeIndication.getInstance(null);
        if (commitmentTypeIndication != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            CommitmentTypeIndication.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(CommitmentTypeIndication commitmentTypeIndication, DERObjectIdentifier dERObjectIdentifier, ASN1Encodable aSN1Encodable) throws IOException {
        this.checkStatement(commitmentTypeIndication, dERObjectIdentifier, aSN1Encodable);
        commitmentTypeIndication = CommitmentTypeIndication.getInstance(commitmentTypeIndication);
        this.checkStatement(commitmentTypeIndication, dERObjectIdentifier, aSN1Encodable);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(commitmentTypeIndication.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        commitmentTypeIndication = CommitmentTypeIndication.getInstance(aSN1Sequence);
        this.checkStatement(commitmentTypeIndication, dERObjectIdentifier, aSN1Encodable);
    }

    private void checkStatement(CommitmentTypeIndication commitmentTypeIndication, DERObjectIdentifier dERObjectIdentifier, ASN1Encodable aSN1Encodable) {
        if (!commitmentTypeIndication.getCommitmentTypeId().equals(dERObjectIdentifier)) {
            this.fail("commitmentTypeIds don't match.");
        }
        if (aSN1Encodable != null) {
            if (!commitmentTypeIndication.getCommitmentTypeQualifier().equals(aSN1Encodable)) {
                this.fail("qualifiers don't match.");
            }
        } else if (commitmentTypeIndication.getCommitmentTypeQualifier() != null) {
            this.fail("qualifier found when none expected.");
        }
    }

    public static void main(String[] stringArray) {
        CommitmentTypeIndicationUnitTest.runTest(new CommitmentTypeIndicationUnitTest());
    }
}

