/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class Iso4217CurrencyCodeUnitTest
extends SimpleTest {
    private static final String ALPHABETIC_CURRENCY_CODE = "AUD";
    private static final int NUMERIC_CURRENCY_CODE = 1;

    public String getName() {
        return "Iso4217CurrencyCode";
    }

    public void performTest() throws Exception {
        Iso4217CurrencyCode iso4217CurrencyCode = new Iso4217CurrencyCode(ALPHABETIC_CURRENCY_CODE);
        this.checkNumeric(iso4217CurrencyCode, ALPHABETIC_CURRENCY_CODE);
        iso4217CurrencyCode = Iso4217CurrencyCode.getInstance(iso4217CurrencyCode);
        this.checkNumeric(iso4217CurrencyCode, ALPHABETIC_CURRENCY_CODE);
        DERObject dERObject = iso4217CurrencyCode.toASN1Object();
        iso4217CurrencyCode = Iso4217CurrencyCode.getInstance(dERObject);
        this.checkNumeric(iso4217CurrencyCode, ALPHABETIC_CURRENCY_CODE);
        iso4217CurrencyCode = new Iso4217CurrencyCode(1);
        this.checkNumeric(iso4217CurrencyCode, 1);
        iso4217CurrencyCode = Iso4217CurrencyCode.getInstance(iso4217CurrencyCode);
        this.checkNumeric(iso4217CurrencyCode, 1);
        dERObject = iso4217CurrencyCode.toASN1Object();
        iso4217CurrencyCode = Iso4217CurrencyCode.getInstance(dERObject);
        this.checkNumeric(iso4217CurrencyCode, 1);
        iso4217CurrencyCode = Iso4217CurrencyCode.getInstance(null);
        if (iso4217CurrencyCode != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            Iso4217CurrencyCode.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Iso4217CurrencyCode("ABCD");
            this.fail("constructor failed to detect out of range currencycode.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Iso4217CurrencyCode(0);
            this.fail("constructor failed to detect out of range small numeric code.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new Iso4217CurrencyCode(1000);
            this.fail("constructor failed to detect out of range large numeric code.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkNumeric(Iso4217CurrencyCode iso4217CurrencyCode, String string) {
        if (!iso4217CurrencyCode.isAlphabetic()) {
            this.fail("non-alphabetic code found when one expected.");
        }
        if (!iso4217CurrencyCode.getAlphabetic().equals(string)) {
            this.fail("string codes don't match.");
        }
    }

    private void checkNumeric(Iso4217CurrencyCode iso4217CurrencyCode, int n) {
        if (iso4217CurrencyCode.isAlphabetic()) {
            this.fail("alphabetic code found when one not expected.");
        }
        if (iso4217CurrencyCode.getNumeric() != n) {
            this.fail("numeric codes don't match.");
        }
    }

    public static void main(String[] stringArray) {
        Iso4217CurrencyCodeUnitTest.runTest(new Iso4217CurrencyCodeUnitTest());
    }
}

