/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OutputStream;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DEROutputStream;
import edu.illinois.ncsa.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class OIDTest
extends SimpleTest {
    byte[] req1 = Hex.decode("0603813403");
    byte[] req2 = Hex.decode("06082A36FFFFFFDD6311");

    public String getName() {
        return "OID";
    }

    private void recodeCheck(String string, byte[] byArray) throws IOException {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)aSN1InputStream.readObject();
        if (!dERObjectIdentifier.equals(dERObjectIdentifier2)) {
            this.fail("oid ID didn't match", dERObjectIdentifier, dERObjectIdentifier2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dERObjectIdentifier);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length != byArray.length) {
            this.fail("failed length test");
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            this.fail("failed comparison test", new String(Hex.encode(byArray)), new String(Hex.encode(byArray2)));
        }
    }

    private void validOidCheck(String string) throws IOException {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(dERObjectIdentifier);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        dERObjectIdentifier = (DERObjectIdentifier)aSN1InputStream.readObject();
        if (!dERObjectIdentifier.getId().equals(string)) {
            this.fail("failed oid check for " + string);
        }
    }

    private void invalidOidCheck(String string) {
        try {
            new DERObjectIdentifier(string);
            this.fail("failed to catch bad oid: " + string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void performTest() throws IOException {
        this.recodeCheck("2.100.3", this.req1);
        this.recodeCheck("1.2.54.34359733987.17", this.req2);
        this.validOidCheck(PKCSObjectIdentifiers.pkcs_9_at_contentType.getId());
        this.validOidCheck("0.1");
        this.validOidCheck("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
        this.validOidCheck("1.2.123.12345678901.1.1.1");
        this.validOidCheck("2.25.196556539987194312349856245628873852187.1");
        this.invalidOidCheck("0");
        this.invalidOidCheck("1");
        this.invalidOidCheck("2");
        this.invalidOidCheck("3.1");
        this.invalidOidCheck("..1");
        this.invalidOidCheck("192.168.1.1");
        this.invalidOidCheck(".123452");
        this.invalidOidCheck("1.");
        this.invalidOidCheck("1.345.23.34..234");
        this.invalidOidCheck("1.345.23.34.234.");
        this.invalidOidCheck(".12.345.77.234");
        this.invalidOidCheck(".12.345.77.234.");
        this.invalidOidCheck("1.2.3.4.A.5");
        this.invalidOidCheck("1,2");
    }

    public static void main(String[] stringArray) {
        OIDTest.runTest(new OIDTest());
    }
}

