/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.ocsp.RequestedCertificate;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509CertificateStructure;
import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import java.io.IOException;

public class RequestedCertificateUnitTest
extends ASN1UnitTest {
    byte[] certBytes = Base64.decode("MIIBWzCCAQYCARgwDQYJKoZIhvcNAQEEBQAwODELMAkGA1UEBhMCQVUxDDAKBgNVBAgTA1FMRDEbMBkGA1UEAxMSU1NMZWF5L3JzYSB0ZXN0IENBMB4XDTk1MDYxOTIzMzMxMloXDTk1MDcxNzIzMzMxMlowOjELMAkGA1UEBhMCQVUxDDAKBgNVBAgTA1FMRDEdMBsGA1UEAxMUU1NMZWF5L3JzYSB0ZXN0IGNlcnQwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAqtt6qS5GTxVxGZYWa0/4u+IwHf7p2LNZbcPBp9/OfIcYAXBQn8hO/Re1uwLKXdCjIoaGs4DLdG88rkzfyK5dPQIDAQABMAwGCCqGSIb3DQIFBQADQQAEWc7EcF8po2/ZO6kNCwK/ICH6DobgLekA5lSLr5EvuioZniZp5lFzAw4+YzPQ7XKJzl9HYIMxATFyqSiD9jsx");

    public String getName() {
        return "RequestedCertificate";
    }

    public void performTest() throws Exception {
        int n = 1;
        byte[] byArray = new byte[20];
        X509CertificateStructure x509CertificateStructure = new X509CertificateStructure((ASN1Sequence)new ASN1InputStream(this.certBytes).readObject());
        RequestedCertificate requestedCertificate = new RequestedCertificate(n, byArray);
        this.checkConstruction(requestedCertificate, n, byArray, null);
        requestedCertificate = new RequestedCertificate(x509CertificateStructure);
        this.checkConstruction(requestedCertificate, -1, null, x509CertificateStructure);
        requestedCertificate = RequestedCertificate.getInstance(null);
        if (requestedCertificate != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            RequestedCertificate.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(RequestedCertificate requestedCertificate, int n, byte[] byArray, X509CertificateStructure x509CertificateStructure) throws IOException {
        this.checkValues(requestedCertificate, n, byArray, x509CertificateStructure);
        requestedCertificate = RequestedCertificate.getInstance(requestedCertificate);
        this.checkValues(requestedCertificate, n, byArray, x509CertificateStructure);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(requestedCertificate.toASN1Object().getEncoded());
        DERObject dERObject = aSN1InputStream.readObject();
        requestedCertificate = RequestedCertificate.getInstance(dERObject);
        this.checkValues(requestedCertificate, n, byArray, x509CertificateStructure);
    }

    private void checkValues(RequestedCertificate requestedCertificate, int n, byte[] byArray, X509CertificateStructure x509CertificateStructure) throws IOException {
        this.checkMandatoryField("certType", n, requestedCertificate.getType());
        if (requestedCertificate.getType() == -1) {
            this.checkMandatoryField("certificate", x509CertificateStructure.getEncoded(), requestedCertificate.getCertificateBytes());
        } else {
            this.checkMandatoryField("certificateOctets", byArray, requestedCertificate.getCertificateBytes());
        }
    }

    public static void main(String[] stringArray) {
        RequestedCertificateUnitTest.runTest(new RequestedCertificateUnitTest());
    }
}

