/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.generators;

import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPair;
import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.KeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHKeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

